% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-tool.R
\docType{class}
\name{Tool-class}
\alias{Tool-class}
\alias{Tool}
\title{Class Tool}
\value{
a Tool object.
}
\description{
code{Tool} class extends \code{CommandLineTool}
with more seven bridges flabored fields the \code{SBG} class.
\code{obj$toJSON()}, \code{obj$toJSON(pretty = TRUE)} or
\code{obj$toYAML()} will convert a
\code{Tool} object into a text JSON/YAML file.
}
\section{Fields}{

\describe{
\item{\code{context}}{[character] by default:
\url{http://www.commonwl.org/draft-2/}}

\item{\code{owner}}{[list] a list of owner names.}

\item{\code{contributor}}{[list] a list of contributor names.}
}}

\section{Methods}{

\describe{
\item{\code{copy_obj()}}{this is a hack to make copy of reference cwl object}

\item{\code{get_input(name = NULL, id = NULL)}}{get input objects by names or id}

\item{\code{get_input_port()}}{the inputs node with \code{sbg:includeInPorts} equals \code{TRUE}}

\item{\code{get_output(name = NULL, id = NULL)}}{get output objects by names or id}

\item{\code{get_required()}}{return required input fields types, names of them are input id}

\item{\code{input_id(full = FALSE, requiredOnly = FALSE)}}{Get input id from a Tool, when full = TRUE, connect tool id with input id. e.g. If requiredOnly = TRUE, return required field only.}

\item{\code{input_matrix(
  new.order = c("id", "label", "type", "required", "prefix", "fileTypes"),
  required = NULL
)}}{This return a matrix of input parameters, by default, following the order id, label, type, required, prefix, fileTypes. new.order accept names of column you want to print, but it has to be a field of inputs. When its set to NULL, it prints all fields. When required = TRUE, only print required field.}

\item{\code{input_type()}}{this return a vector of types, names of them are input id}

\item{\code{output_id(full = FALSE)}}{Get output id from a Tool, when full = TRUE, connect tool id with input id.}

\item{\code{output_matrix(new.order = c("id", "label", "type", "fileTypes"))}}{This return a matrix of output parameters, by default, following the order id, label, type, fileTypes. new.order accept names of column you want to print, but it has to be a field of outputs. When its set to NULL, it prints all fields. when required = TRUE, only print required field.}

\item{\code{output_type()}}{this return a vector of types, names of them are output id}

\item{\code{run(run_inputs = list(), engine = c("bunny", "rabix", "cwlrun"))}}{Run this tool with inputs locally. Engines supported: bunny, rabix, cwlrun. Inputs accept list or JSON.}

\item{\code{set_input_port(ids, include = TRUE)}}{Set inputs ports field sbg:includeInPorts to the value of include, default is TRUE.}

\item{\code{set_required(ids, required = TRUE)}}{Set an input node required or not required. The first parameter takes single input id or more than one ids. The second parameters required is the value you want to set to inputs. TRUE means set to required.}
}}

\examples{
t1 <- system.file("extdata/app", "tool_star.json", package = "sevenbridges")
# convert json file into a Tool object
t1 <- convert_app(t1)
# get input type information
t1$input_type()
# get output type information
t1$output_type()
# return a input matrix with more informtion
t1$input_matrix()
# return only a few fields
t1$input_matrix(c("id", "type", "required"))
# return only required
t1$input_matrix(required = TRUE)
# return everything
t1$input_matrix(NULL)
# return a output matrix with more informtion
t1$output_matrix()
# return only a few fields
t1$output_matrix(c("id", "type"))
# return everything
t1$output_matrix(NULL)
# get input id
t1$input_id()
# get full input id with Tool name
t1$input_id(TRUE)
# get output id
t1$output_id()
# get full output id
t1$output_id(TRUE)
# get required input id
t1$get_required()
# set input required
t1$set_required(c("#reads", "winFlankNbins"))
t1$get_required()
t1$set_required("reads", FALSE)
t1$get_required()
t1$get_input(name = "ins")
t1$get_input(id = "#winFlankNbins")
t1$get_output(name = "gene")
t1$get_output(id = "#aligned_reads")
# get a tool from a flow
f1 <- system.file("extdata/app", "flow_star.json", package = "sevenbridges")
# convert json file into a Tool object
f1 <- convert_app(f1)
t2 <- f1$get_tool("STAR$")
oid <- t2$get_input_port()
oid
# set new ports
t2$input_id()
t2$set_input_port("#chimScoreSeparation")
t2$get_input_port()
t2$set_input_port("#chimScoreSeparation", FALSE)
t2$get_input_port()
# run the tool locally with example data
\dontrun{
t3 <- system.file("extdata/app/dna2protein", "translate.cwl.json", package = "sevenbridges")
t3 <- convert_app(t3)
fl <- system.file("extdata/app/dna2protein/data", "input.txt", package = "sevenbridges")
set_test_env("dind", "tengfei/testenv", "~/mounts")
t3$input_type()
t3$run(list(input_file = Files(fl)))  # Not File}
}
