% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-files.R
\docType{class}
\name{Files-class}
\alias{Files-class}
\alias{Files}
\alias{FilesList}
\alias{FilesList-class}
\title{Class Files}
\usage{
FilesList(...)
}
\arguments{
\item{...}{one or more \code{Files} objects}
}
\value{
Files object
}
\description{
Class Files
}
\details{
\code{Files} (with "\code{s}") class is usally returned by the API call
which returns Files. A group of \code{Files} is defined as \code{FilesList}.
Users do not usually need to construct \code{Files} or \code{FilesList}
manually, they are generated from a API call most of the time.
}
\section{Fields}{

\describe{
\item{\code{id}}{character used as file id}

\item{\code{name}}{string used as file name}

\item{\code{size}}{file size}

\item{\code{project}}{project id if any, when returned by a API call,
it usually return the project id and stored with the object.}

\item{\code{created_on}}{date created on}

\item{\code{modified_on}}{date modified on}

\item{\code{storage}}{list as storage type}

\item{\code{origin}}{list as origin}

\item{\code{tags}}{list as tags}

\item{\code{metadata}}{a list for metadata associated with the file}

\item{\code{url}}{file download url}

\item{\code{parent}}{parent folder ID}

\item{\code{type}}{\code{"FILE"} or \code{"FOLDER"}}

\item{\code{description}}{file description}
}}

\section{Methods}{

\describe{
\item{\code{add_tag(x, ...)}}{add new tags while keeping old tags}

\item{\code{copy_to(project = NULL, name = NULL)}}{copy a file to a project (id) with new name}

\item{\code{copy_to_folder(folder_id, name_new = NULL, ...)}}{Copy a file to a folder.}

\item{\code{create_folder(name, ...)}}{Create a new folder under the parent folder.}

\item{\code{create_marker(
  name = NULL,
  start = NULL,
  end = NULL,
  chromosome = NULL,
  private = TRUE,
  ...
)}}{Create a marker.}

\item{\code{download(destfile, ..., method = "curl")}}{see `help(download.file)` for more options}

\item{\code{get_parent_folder()}}{Get the parent folder object of the current file/folder.}

\item{\code{get_parent_folder_id()}}{Get the parent folder ID of the current file/folder.}

\item{\code{list_folder_contents(type = c("file", "folder"), ...)}}{List folder contents (return files, folders, or both).}

\item{\code{marker(id = NULL, ...)}}{List markers available on a file or get details for a marker.}

\item{\code{meta()}}{get metadata from a file}

\item{\code{move_to_folder(folder_id, name_new = NULL, ...)}}{Move a file to a folder.}

\item{\code{setMeta(..., overwrite = FALSE)}}{Set metadata with provided list, when overwrite is set to TRUE, it overwrites the metadata.}

\item{\code{set_meta(..., overwrite = FALSE)}}{Set metadata with provided list, when overwrite is set to TRUE, it overwrites the metadata.}

\item{\code{set_tag(x = NULL, overwrite = TRUE, ...)}}{set a tag for a file, your tag need to be a list or vector}

\item{\code{tag()}}{get tag from a file}

\item{\code{typeof()}}{Get object type ("file" or "folder").}

\item{\code{update(name = NULL, metadata = NULL, tags = NULL)}}{This call updates the name, the full set metadata, and tags for a specified file.}
}}

\note{
In the sevenbridges package version <= 1.5.4, the \code{Files} class
inherited from the \code{File} class defined in CWL. To avoid confusion,
in the current implementation, they are defined separately and not
coupled anymore.
}
\examples{
Files(id = "test_id", name = "test.bam")
}
