% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{class}
\name{CommandOutputBinding-class}
\alias{CommandOutputBinding-class}
\alias{CommandOutputBinding}
\title{CommandOutputBinding Class}
\description{
Describes how to generate an output parameter based on the files
produced by a CommandLineTool. The output parameter is generated
by applying these operations in the following order:
glob, loadContents, outputEval.
}
\section{Fields}{

\describe{
\item{\code{glob}}{[characterORExpression] Find files relative to the
output directory, using POSIX glob(3) pathname matching. If
provided an array, match all patterns in the array. If provided an
expression, the expression must return a string or an array of
strings, which will then be evaluated as a glob pattern. Only files
which actually exist will be matched and returned.}

\item{\code{outputEval}}{[Expression] Evaluate an expression to generate
the output value. If glob was specified, the script context will be
an array containing any files that were matched. Additionally, if
loadContents is true, the file objects will include up to the first
64 KiB of file contents in the contents field.}
}}


\examples{
CommandOutputBinding(glob = "*.bam")
}
