% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-auth.R
\docType{class}
\name{Auth-class}
\alias{Auth-class}
\alias{Auth}
\title{Class Auth}
\description{
Auth object
}
\details{
Every object could be requested from this Auth object and any action
could start from this object using cascading style. Please check
\code{vignette("api")} for more information.
}
\section{Fields}{

\describe{
\item{\code{from}}{[character] Authentication method. Could be \code{"direct"}
(pass the credential information to the arguments directly),
\code{"env"} (read from pre-set system environment variables),
or \code{"file"} (read configurations from a credentials file).
Default is \code{"direct"}.}

\item{\code{platform}}{[character] The platform to use.
If \code{platform} and \code{url} are both not specified,
the default is \code{"cgc"} (Cancer Genomics Cloud).
Other possible values include
\code{"aws-us"} (Seven Bridges Platform - US),
\code{"aws-eu"} (Seven Bridges Platform - EU),
\code{"ali-cn"} (Seven Bridges Platform - China),
\code{"cavatica"} (Cavatica), and
\code{"f4c"} (BioData Catalyst Powered by Seven Bridges).}

\item{\code{url}}{[character] Base URL for API. Please only use this when you
want to specify a platform that is not in the \code{platform} list
above, and also leaving \code{platform} unspecified.}

\item{\code{token}}{[character] Your authentication token.}

\item{\code{sysenv_url}}{Name of the system environment variable storing
the API base URL. By default: \code{"SB_API_ENDPOINT"}.}

\item{\code{sysenv_token}}{Name of the system environment variable storing
the auth token. By default: \code{"SB_AUTH_TOKEN"}.}

\item{\code{config_file}}{[character] Location of the user configuration file.
By default: \code{"~/.sevenbridges/credentials"}.}

\item{\code{profile_name}}{[character] Profile name in the user configuration file.
The default value is \code{"default"}.}

\item{\code{fs}}{FS object, for mount and unmount file system.}

\item{\code{authorization}}{Logical. Is the \code{token} an API
auth token (\code{FALSE}) or an access token from the
Seven Bridges single sign-on (\code{TRUE})?}
}}

\section{Methods}{

\describe{
\item{\code{api(
  ...,
  limit = getOption("sevenbridges")$limit,
  offset = getOption("sevenbridges")$offset,
  fields = NULL,
  complete = FALSE
)}}{This call returns all API paths, and pass arguments to api() function with input token and url automatically}

\item{\code{billing(id = NULL, breakdown = FALSE, ...)}}{If no id provided, This call returns a list of paths used to access billing information via the API. else, This call lists all your billing groups, including groups that are pending or have been disabled. If breakdown = TRUE, This call returns a breakdown of spending per-project for the billing group specified by billing_group. For each project that the billing group is associated with, information is shown on the tasks run, including their initiating user (the runner), start and end times, and cost.}

\item{\code{bulk_file_copy(file_ids, project, ...)}}{Copy files between projects in a batch.}

\item{\code{bulk_file_delete(file_ids, ...)}}{Delete multiple files.}

\item{\code{bulk_file_edit(...)}}{Edit details of multiple files (preserving the omitted fields).}

\item{\code{bulk_file_get(file_ids, ...)}}{Get details of multiple files.}

\item{\code{bulk_file_update(...)}}{Update details of multiple files (removing the omitted fields).}

\item{\code{bulk_task_get(task_ids, ...)}}{Get details of multiple tasks.}

\item{\code{bulk_volume_export(...)}}{Bulk export to volumes.}

\item{\code{bulk_volume_get_export(...)}}{Get details of a bulk export job.}

\item{\code{bulk_volume_get_import(...)}}{Get details of a bulk import job.}

\item{\code{bulk_volume_import(...)}}{Bulk import from volumes.}

\item{\code{division(id = NULL, ...)}}{List all divisions or get details of a division.}

\item{\code{file(
  name = NULL,
  id = NULL,
  project = NULL,
  exact = FALSE,
  detail = FALSE,
  metadata = list(),
  origin.task = NULL,
  tag = NULL,
  complete = FALSE,
  search.engine = c("server", "brute"),
  ...
)}}{This call returns a list of all files in a specified project that you can access. For each file, the call returns: 1) Its ID 2) Its filename The project is specified as a query parameter in the call.}

\item{\code{invoice(id = NULL, ...)}}{If no id provided, This call returns a list of invoices, with information about each, including whether or not the invoice is pending and the billing period it covers. The call returns information about all your available invoices, unless you use the query parameter bg_id to specify the ID of a particular billing group, in which case it will return the invoice incurred by that billing group only. If id was provided, This call retrieves information about a selected invoice, including the costs for analysis and storage, and the invoice period.}

\item{\code{project(
  name = NULL,
  id = NULL,
  index = NULL,
  ignore.case = TRUE,
  exact = FALSE,
  owner = NULL,
  detail = FALSE,
  ...
)}}{If no id or name provided, this call returns a list of all projects you are a member of. Each project's project_id and URL on the platform will be returned. If name or id provided, we do a match search the list.}

\item{\code{project_new(
  name = NULL,
  billing_group_id = NULL,
  description = name,
  tags = list(),
  type = "v2",
  locked = FALSE,
  use_interruptible_instances = FALSE,
  ...
)}}{Create new projects, required parameters: name, billing_group_id, optional parameteres: tags, description, type, and settings.}

\item{\code{project_owner(owner = NULL, ...)}}{List the projects owned by and accessible to a particular user. Each project's ID and URL will be returned.}

\item{\code{rate_limit(...)}}{This call returns information about your current rate limit. This is the number of API calls you can make in one hour.}

\item{\code{send_feedback(
  text,
  type = c("idea", "thought", "problem"),
  referrer = NULL,
  ...
)}}{Send feedback to Seven Bridges.}

\item{\code{user(username = NULL, ...)}}{This call returns information about the authenticated user.}

\item{\code{volume(
  name = NULL,
  id = NULL,
  index = NULL,
  ignore.case = TRUE,
  exact = FALSE,
  detail = FALSE,
  ...
)}}{If no id or name provided, this call returns a list of all volumes you are a member of. If name or id provided, we did a match search the list.}
}}

\examples{
# Direct authentication (default)
# replace with your auth token
token <- "your_token"
a <- Auth(platform = "cgc", token = token)
\dontrun{
# Authentication with environment variables
# This will read system environments variables
# `SB_API_ENDPOINT` and `SB_AUTH_TOKEN` by default
a <- Auth(from = "env")

# Authentication with user configuration file
# This will load profile `default` from config
# file `~/.sevenbridges/credentials` by default
a <- Auth(from = "file")
}
}
