% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{motif.hg19.CTCF}
\alias{motif.hg19.CTCF}
\title{CTCF motif locations in human genome hg19.}
\format{
\code{\link[GenomicRanges:GRanges-class]{GRanges}} object with 38774 ranges on
positive and negative strand with 1 meta column:

  \describe{ \item{score}{
  The significance socre of the motif hit, defined as -log_10(p-value).
  }
  }
}
\source{
\url{http://expdata.cmmt.ubc.ca/JASPAR/downloads/UCSC_tracks/2018/hg19/tsv/MA0139.1.tsv.gz}
}
\usage{
motif.hg19.CTCF
}
\description{
A dataset containing the motif hits of the CTCF recognition motif from JASPAR
database (MA0139.1, \url{http://jaspar.genereg.net/matrix/MA0139.1/}) in human
genome assembly hg19.
}
\details{
The dataset was downloaded from JASPAR 2018 motif tracks from the following
URL:
\url{http://expdata.cmmt.ubc.ca/JASPAR/downloads/UCSC_tracks/2018/hg19/tsv/MA0139.1.tsv.gz}

Motif locations were filtered to contain only motif hists with p-value
\eqn{\le 2.5 * 10^-6}.
The p-value is the motif hit significance as repoted from the
motif scanning alogrithim used during construction of the JASPAR motif
tracks. More information on the JASPAR motif track pipeline can be found
here:
\url{https://github.com/wassermanlab/JASPAR-UCSC-tracks}.
}
\keyword{datasets}
