% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseChIP-seq.R
\name{addCovToGR}
\alias{addCovToGR}
\title{Add coverage to regions in \code{\link[GenomicRanges:GRanges-class]{GRanges}} object.}
\usage{
addCovToGR(gr, bwFile, window = 1000, binSize = 1, colname = "chip")
}
\arguments{
\item{gr}{\code{\link[GenomicRanges:GRanges-class]{GRanges}} object with genomic regions. It
should contain a valid seqinfo object with defined seqlengths.}

\item{bwFile}{File path or connection to BigWig or wig file with coverage to
parse from.}

\item{window}{Numeric scalar for window size around the center of ranges in
\code{gr}.}

\item{binSize}{Integer scalar as size of bins to which the coverage values are
combined.}

\item{colname}{Character as name of the new column that is created in
\code{gr}.}
}
\value{
\code{\link[GenomicRanges:GRanges-class]{GRanges}} as input but with an additional
 meta column containing the coverage values for each region as
 \code{\link[IRanges:AtomicList-class]{NumericList}}.
}
\description{
This function adds a \code{\link[IRanges:AtomicList-class]{NumericList}}  of coverage (or any
other signal in the input bigWig file) to each range in a
\code{\link[GenomicRanges:GRanges-class]{GRanges}} object. The coverage is reported for a
fixed-sized window around the region center. For regions with negative strand,
the coverage vector is reversed. The coverage signal is added as new metadata
column holding a \code{\link[IRanges:AtomicList-class]{NumericList}} object. Note, this
function does not work on windows because reading of bigWig files is currently
not supported on windows.
}
\examples{
if (.Platform$OS.type != "windows") {

 # use example bigWig file of ChIP-seq signals on human chromosome 22
 exampleBigWig <- system.file("extdata",
 "GM12878_Stat1.chr22_1-30000000.bigWig", package = "sevenC")

 # use example CTCF moitf location on human chromosome 22
 motifGR <- sevenC::motif.hg19.CTCF.chr22

 # add ChIP-seq signals to motif regions
 motifGR <- addCovToGR(motifGR, exampleBigWig)

 # add ChIP-seq signals as column named "Stat1"
 motifGR <- addCovToGR(motifGR, exampleBigWig, colname = "Stat1")

 # add ChIP-seq signals in windows of 500bp around motif centers
 motifGR <- addCovToGR(motifGR, exampleBigWig, window = 500)

 # add ChIP-seq signals in bins of 10 bp
 motifGR <- addCovToGR(motifGR, exampleBigWig, binSize = 10)

}
}
