% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualizeProbes}
\alias{visualizeProbes}
\title{Visualize Region that Contains the Specified Probes}
\usage{
visualizeProbes(
  probeNames,
  betas,
  platform = NULL,
  genome = NULL,
  upstream = 1000,
  dwstream = 1000,
  ...
)
}
\arguments{
\item{probeNames}{probe names}

\item{betas}{beta value matrix (row: probes, column: samples)}

\item{platform}{HM450, EPIC or MM285 (default)}

\item{genome}{hg19, hg38 or mm10 (default)}

\item{upstream}{distance to extend upstream}

\item{dwstream}{distance to extend downstream}

\item{...}{additional options, see visualizeRegion and assemble_plots}
}
\value{
None
}
\description{
Visualize the beta value in heatmaps for the genomic region containing
specified probes. The function works only if specified probes can be
spanned by a single genomic region. The region can cover more probes
than specified. Hence the plotting heatmap may encompass more probes.
The function takes as input a string vector of probe IDs (cg/ch/rs-numbers).
if draw is FALSE, the function returns the subset beta value matrix
otherwise it returns the grid graphics object.
}
\examples{
betas <- sesameDataGet('HM450.76.TCGA.matched')$betas
visualizeProbes(c('cg22316575', 'cg16084772', 'cg20622019'), betas, 'HM450')
}
