% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_impacts.R
\name{plot_impacts}
\alias{plot_impacts}
\title{Plot SNV impact distribution}
\usage{
plot_impacts(comparison, legend = TRUE, annotate = TRUE,
  annotate_size = 9, text_size = 14, palette = c("#0D2D59",
  "#1954A6"))
}
\arguments{
\item{comparison}{The SNV profile comparison to be plotted.}

\item{legend}{Show the legend (boolean).}

\item{annotate}{Annotate each category (boolean).}

\item{annotate_size}{Text size for annotations (numeric).}

\item{text_size}{Text size for axes, ticks and legend (numeric).}

\item{palette}{Colour palette for filling of bars (character vector).}
}
\value{
A ggplot2 graphical object.
}
\description{
Plot SNV impact distributions for a binary SNV profile
 comparison.
}
\details{
This function creates publication-ready plots of the impact
distribution from a binary dataset comparison across the matched/mismatched
SNVs.
}
\examples{
# Load test comparison data
data(test_comparison)

# Plot the impact distribution
impacts <- plot_impacts(test_comparison)
}
