% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_variants.R
\name{list_variants}
\alias{list_variants}
\title{List known variants}
\usage{
list_variants(profiles, known_variants)
}
\arguments{
\item{profiles}{The SNV profiles to analyse (list)}

\item{known_variants}{The known variants to look for (dataframe)}
}
\value{
A dataframe containing the known variant genotypes in each profile.
}
\description{
List known variants present in SNV profiles
}
\details{
This is a function for listing known variants present in SNV
 profiles. Input is a list of profiles and a dataframe of known variants,
 containing at least the genomic locations ("chr" and "pos"). Any additional
 columns will be retained.
}
\examples{
# Load test data
data(test_profile_1)
data(test_profile_2)

# Create some variants to analyse
known_variants <- data.frame(chr = 1, pos = 16229, gene = "DDX11L1")

# List the known variants in each profile
profiles <- list(test_profile_1, test_profile_2)
known_variants <- list_variants(profiles, known_variants)
}
