% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_profile.R
\name{create_profiles}
\alias{create_profiles}
\title{SNV profile creation}
\usage{
create_profiles(vcf_dir, min_depth = 10, filter_vc = TRUE,
  filter_mt = TRUE, filter_ns = TRUE, filter_gd = TRUE,
  filter_pd = FALSE, pattern = NULL, recursive = FALSE)
}
\arguments{
\item{vcf_dir}{The VCF directory from which the profiles will be created
(path).}

\item{min_depth}{Remove variants below this sequencing depth (integer).}

\item{filter_vc}{Filter variants failing variant caller criteria (boolean).}

\item{filter_mt}{Filter mitochondrial variants (boolean).}

\item{filter_ns}{Filter non-standard chromosomes (boolean).}

\item{filter_gd}{Filter duplicate variants at the gene-level (boolean).}

\item{filter_pd}{Filter duplicate variants at the position-level (boolean).}

\item{pattern}{Only create profiles for a subset of files corresponding to
this pattern (character).}

\item{recursive}{Find VCF files recursively in sub-directories as well
(boolean).}
}
\value{
A list of data frames.
}
\description{
Create SNV profiles from all VCF files in a directory
}
\details{
This functions is a convenience-wrapper for the `create_profile`
function, which will create SNV profiles for each and every VCF file in the
provided directory. The file naming scheme used is `<sample>.vcf` and will
dictate the each profile's sample name.
}
\examples{
# Path to the test VCF directory
vcf_dir = system.file("extdata", package = "seqCAT")

# Create SNV profiles
profiles <- create_profiles(vcf_dir, pattern = "test", recursive = TRUE)
}
