% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_profile.R
\name{create_profile}
\alias{create_profile}
\title{SNV profile creation}
\usage{
create_profile(vcf_file, sample, min_depth = 10, filter_vc = TRUE,
  filter_mt = TRUE, filter_ns = TRUE, filter_gd = TRUE,
  filter_pd = FALSE)
}
\arguments{
\item{vcf_file}{The VCF file from which the profile will be created (path).}

\item{sample}{The sample in the VCF for which a profile will be created
(character).}

\item{min_depth}{Filter variants below this sequencing depth (integer).}

\item{filter_vc}{Filter variants failing variant caller criteria (boolean).}

\item{filter_mt}{Filter mitochondrial variants (boolean).}

\item{filter_ns}{Filter non-standard chromosomes (boolean).}

\item{filter_gd}{Filter duplicate variants at the gene-level (boolean).}

\item{filter_pd}{Filter duplicate variants at the position-level (boolean).}
}
\value{
A data frame.
}
\description{
Create an SNV profile from data in a VCF file.
}
\details{
This function creates a SNV profile from a given VCF file by
extracting the variants that pass the filtering criterias. Profile creation
is performed to facilitate and accelerate the cell authentication
procedures, which is especially relevant when more than one pairwise
comparison will be performed on the same sample.
}
\examples{
# Path to the test VCF file
vcf_file = system.file("extdata", "test.vcf.gz", package = "seqCAT")

# Create SNV profiles
profile_1 <- create_profile(vcf_file, "sample1")
profile_1 <- create_profile(vcf_file, "sample1", min_depth = 15)
}
