% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scrutor}
\alias{scrutor}
\title{Hypothesis testing}
\usage{
scrutor(Y, Z, dist = "norm",
        phi = NULL, pi = NULL, gamma = NULL,
        test = "perm", iter = NULL, kind = NULL,
        debug = TRUE, ...)
}
\arguments{
\item{Y}{\strong{observations:}
numeric vector of length \code{n},
or numeric matrix with \code{n} rows (samples)
and \code{q} columns (variables)}

\item{Z}{\strong{class labels:}
numeric vector of length \code{n},
or numeric matrix with \code{n} rows (samples)
and \code{p} columns (variables),
with entries \code{0} and \code{NA}}

\item{dist}{distributional assumption\strong{:}
character \code{"norm"} (Gaussian),
\code{"nbinom"} (negative bionomial),
or \code{"zinb"} (zero-inflated negative binomial)}

\item{phi}{dispersion parameter(s)\strong{:}
numeric vector of length \code{q},
or \code{NULL} (\code{norm:} none, \code{nbinom:} MLE)}

\item{pi}{zero-inflation parameter(s)\strong{:}
numeric vector of length \code{q},
or \code{NULL} (\code{norm:} none,\code{nbinom:} MLE)}

\item{gamma}{offset\strong{:}
numeric vector of length \code{n},
or \code{NULL}}

\item{test}{resampling procedure\strong{:}
character \code{"perm"} (permutation) or
\code{"boot"} (parametric bootstrap),
or \code{NULL}}

\item{iter}{(maximum) number of resampling iterations \strong{:}
positive integer, or \code{NULL}}

\item{kind}{resampling accuracy\strong{:}
numeric between \code{0} and \code{1}, or \code{NULL}\strong{;}
all \code{p}-values above \code{kind} are approximate}

\item{debug}{verification of arguments\strong{:}
\code{TRUE} or \code{FALSE}}

\item{...}{settings \code{EM} algorithm\strong{:}
\code{starts}, \code{it.em} and \code{epsilon}
(see \code{\link{arguments}})}
}
\value{
This function tests a one-component (\code{H0})
against a two-component mixture model (\code{H1}).

\item{y}{index observations}
\item{z}{index class labels}
\item{lrts}{test statistic}
\item{p.value}{\code{p}-value}
}
\description{
This function tests whether the unlabelled observations
come from a mixture of two distributions.
}
\details{
By default, \code{phi} and \code{pi}
are estimated by the maximum likelihood method,
and \code{gamma} is replaced by a vector of ones.
}
\section{Reference}{

A Rauschenberger, RX Menezes, MA van de Wiel,
NM van Schoor, and MA Jonker (2020).
"Semi-supervised mixture test for
detecting markers associated with a quantitative trait",
\emph{Manuscript in preparation}.
}

\examples{
# data simulation
n <- 100
z <- rep(0:1,each=n/2)
y <- rnorm(n=n,mean=2*z,sd=1)
z[(n/4):n] <- NA

# hypothesis testing
scrutor(y,z,dist="norm")

}
\seealso{
Use \code{\link{mixtura}} for model fitting. 
All other functions are \code{\link{internal}}.
}
\keyword{methods}
