
<!-- README.md is generated from README.Rmd. Please edit that file -->

[![Travis-CI Build
Status](https://travis-ci.org/rauschenberger/semisup.svg?branch=master)](https://travis-ci.org/rauschenberger/semisup)
[![AppVeyor build
status](https://ci.appveyor.com/api/projects/status/github/rauschenberger/semisup?svg=true)](https://ci.appveyor.com/project/rauschenberger/semisup)
[![Coverage
Status](https://codecov.io/github/rauschenberger/semisup/coverage.svg?branch=master)](https://codecov.io/github/rauschenberger/semisup?branch=master)

## Scope

Implements a parametric semi-supervised mixture model. The permutation
test detects markers with main or interactive effects, without
distinguishing them. Possible applications include genome-wide
association studies and differential expression analyses.

## Installation

The package semisup depends on [R
\>= 3.0.0](https://cran.r-project.org/), and is available from
[Bioconductor](http://bioconductor.org/packages/semisup/):

``` r
if (!requireNamespace("BiocManager", quietly=TRUE))
    install.packages("BiocManager")
BiocManager::install("semisup")
```

Alternatively, it can be installed from
[GitHub](https://github.com/rauschenberger/semisup). This requires the
package [devtools](https://CRAN.R-project.org/package=devtools):

``` r
devtools::install_github("rauschenberger/semisup",build_vignettes=TRUE)
```

Please restart R before loading the package and its documentation:

``` r
library(semisup)
utils::help(semisup)
utils::vignette("semisup")
```

## Reference

A Rauschenberger, RX Menezes, MA van de Wiel, NM van Schoor, and MA
Jonker (2020). Semi-supervised mixture test for detecting markers
associated with a quantitative trait. Manuscript in preparation.
(outdated version: [html](https://arxiv.org/abs/1805.09175)
[pdf](https://arxiv.org/pdf/1805.09175))

[![Platforms](http://www.bioconductor.org/shields/availability/devel/semisup.svg)](http://bioconductor.org/packages/devel/bioc/html/semisup.html#archives)
[![Downloads](http://www.bioconductor.org/shields/downloads/semisup.svg)](http://bioconductor.org/packages/stats/bioc/semisup/)
[![Posts](http://www.bioconductor.org/shields/posts/semisup.svg)](https://support.bioconductor.org/t/semisup/)
[![in
Bioc](http://www.bioconductor.org/shields/years-in-bioc/semisup.svg)](http://bioconductor.org/packages/devel/bioc/html/semisup.html#since)
[![Build](http://www.bioconductor.org/shields/build/devel/bioc/semisup.svg)](http://bioconductor.org/checkResults/devel/bioc-LATEST/semisup/)
