% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{annotate_segments}
\alias{annotate_segments}
\title{Annotate segments}
\usage{
annotate_segments(segments, ...)
}
\arguments{
\item{segments}{A \code{GRanges} object. Usually the output of calling
\code{segment} on the the output object of \code{lean_model}.}

\item{...}{Other arguments passed to \code{\link[ChIPseeker]{annotatePeak}}}
}
\value{
A \code{GRanges} object which is identical to the input in addition
to the annotations as metadata columns.
}
\description{
Annotate the \code{GRanges} objects of the segments using
\code{\link[ChIPseeker]{annotatePeak}} (see for details)
}
\examples{
library(TxDb.Hsapiens.UCSC.hg18.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg18.knownGene
segs <- segment(test_obj)
segs_annotated <- annotate_segments(segs, TxDb = txdb, verbose = FALSE)

}
