% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gview.R
\name{gview}
\alias{gview}
\title{Visualize gene isoforms}
\usage{
gview(
  gtfFile,
  chr = 1,
  start = 1,
  end = NULL,
  rect_width = 0.3,
  line_width = 0.5,
  arrow_segments = 10,
  arrow_width = 30,
  arrow_length = 0.08,
  arrow_type = "open",
  text_size = 4
)
}
\arguments{
\item{gtfFile}{A genome annotation file in GTF format.}

\item{chr}{Chromosome name. Integer or "X", "Y", "MT".}

\item{start}{Genomic coordinate of the start position.}

\item{end}{Genomic coordinate of the end position. If \code{NULL}, then
the maximum length of the chromosome will be used. Default \code{NULL}.}

\item{rect_width}{Exon widths. Default 0.3.}

\item{line_width}{Line weight. Default 0.5.}

\item{arrow_segments}{The number of segments lines be divided to. The
greater the number, more arrows there are. Default 10.}

\item{arrow_width}{The angle of the arrow head in degrees (smaller numbers
produce narrower, pointier arrows). Essentially describes the width of the
arrow head. Passed to the angle parameter of arrow function. Default 30.}

\item{arrow_length}{The length of the arrow head. Passed to the length
argument of arrow function. Default 0.08.}

\item{arrow_type}{One of "open" or "closed" indicating whether the arrow
head should be a closed triangle. Passed to the type argument of arrow
function. Default "open".}

\item{text_size}{Size of text. Passed to the size argument of the geom_text
function. Default 4.}
}
\value{
A ggplot object of genomic view
}
\description{
Visualize reference genome. Rectangles represent exons. Arrow represents
 orientation of transcripts.
}
\examples{
gtf <- system.file("extdata", "GRCm38_MT.gtf", package = "scruff")
g <- gview(gtf, chr = "MT")
g
}
