% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_runTsne.R
\name{runTsne.se}
\alias{runTsne.se}
\title{t-SNE on a SummarizedExperiment}
\usage{
runTsne.se(
  x,
  perplexity = 30,
  num.threads = 1,
  more.tsne.args = list(),
  reddim.type = "PCA",
  output.name = "TSNE"
)
}
\arguments{
\item{x}{A \link[SingleCellExperiment]{SingleCellExperiment} object or one of its subclasses.
Rows correspond to genomic features and columns correspond to cells.}

\item{perplexity}{Perplexity to use in the t-SNE algorithm, passed to \code{\link{runTsne}}.}

\item{num.threads}{Number of threads for the neighbor search and optimization, passed to \code{\link{runTsne}}.}

\item{more.tsne.args}{Named list of further arguments to pass to \code{\link{runTsne}}.}

\item{reddim.type}{Integer or string specifying the existing embedding in the \code{\link[SingleCellExperiment]{reducedDim}} of \code{x}.
Alternatively, a named integer or character vector of length 1,
where the name specifies an alternative experiment of \code{x} and the value is the name/index of a \code{reducedDim} entry in that alternative experiment.}

\item{output.name}{String containing the name of the output \code{\link[SingleCellExperiment]{reducedDim}}.}
}
\value{
\code{x} is returned with the t-SNE coordinates stored in the \code{reducedDim}.
}
\description{
Generate a t-SNE visualization from an existing embedding,
by calling \code{\link{runUmap}} on a reduced dimension entry in \link[SingleCellExperiment]{SingleCellExperiment}.
}
\examples{
library(SingleCellExperiment)
sce <- getTestRnaData.se("pca")
# Using fewer iterations for a faster-running example.
sce <- runTsne.se(sce, more.tsne.args=list(max.iterations=50))
head(reducedDim(sce, "TSNE"))

}
\author{
Aaron Lun
}
