% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_runAllNeighborSteps.R
\name{runAllNeighborSteps.se}
\alias{runAllNeighborSteps.se}
\title{Run all nearest neighbor steps on a SummarizedExperiment}
\usage{
runAllNeighborSteps.se(
  x,
  umap.output.name = "UMAP",
  more.umap.args = list(),
  tsne.output.name = "TSNE",
  more.tsne.args = list(),
  build.graph.name = NULL,
  more.build.graph.args = list(),
  cluster.output.name = "clusters",
  cluster.meta.name = NULL,
  more.cluster.graph.args = list(),
  BNPARAM = AnnoyParam(),
  num.threads = 3,
  more.neighbor.args = list(),
  reddim.type = "PCA"
)
}
\arguments{
\item{x}{A \link[SingleCellExperiment]{SingleCellExperiment} object or one of its subclasses.
Rows correspond to genomic features and columns correspond to cells.}

\item{umap.output.name}{String containing the name of the \code{\link[SingleCellExperiment]{reducedDim}} entry to store the UMAP coordinates.
If \code{NULL}, the UMAP is not computed.}

\item{more.umap.args}{Named list of additional arguments to pass to \code{\link{runAllNeighborSteps}} as \code{runUmap.args}.}

\item{tsne.output.name}{String containing the name of the \code{\link[SingleCellExperiment]{reducedDim}} entry to store the t-SNE coordinates.
If \code{NULL}, the t-SNE is not computed.}

\item{more.tsne.args}{Named list of additional arguments to pass to \code{\link{runAllNeighborSteps}} as \code{runTsne.args}.}

\item{build.graph.name}{String containing the name of the \code{\link[S4Vectors]{metadata}} entry in which to store the nearest neighbor graph.
If \code{NULL}, the graph is not stored.}

\item{more.build.graph.args}{Named list of additional arguments to pass to \code{\link{runAllNeighborSteps}} as \code{buildSnnGraph.args}.}

\item{cluster.output.name}{String containing the name of the \code{\link[SummarizedExperiment]{colData}} column in which to store the cluster assignments.
If \code{NULL}, graph-based clustering is not performed.}

\item{cluster.meta.name}{String containing the name of the \code{\link[S4Vectors]{metadata}} entry in which to store additional clustering outputs.
If \code{NULL}, these additional outputs are not stored.}

\item{more.cluster.graph.args}{Named list of additional arguments to pass to \code{\link{runAllNeighborSteps}} as \code{clusterGraph.args}.}

\item{BNPARAM, num.threads}{Arguments to pass to \code{\link{runAllNeighborSteps}}.}

\item{more.neighbor.args}{Named list of additional arguments to pass to \code{\link{runAllNeighborSteps}}.}

\item{reddim.type}{String or integer specifying the \code{\link[SingleCellExperiment]{reducedDim}} entry on which to perform a nearest neighbor search.
Alternatively, a named integer or character vector of length 1,
where the name specifies an alternative experiment of \code{x} and the value is the name/index of a \code{reducedDim} entry in that alternative experiment.}
}
\value{
\code{x} is returned with additional coordinates stored in its \code{\link[SingleCellExperiment]{reducedDims}}
and clustering output in its \code{\link[SummarizedExperiment]{colData}}.
Additional information may also be stored in its \code{\link[S4Vectors]{metadata}}.
}
\description{
Concurrently run all steps involving a nearest-neighbor search (t-SNE, UMAP and graph-based clustering) using the same nearest-neighbor index,
by calling \code{\link{runAllNeighborSteps}} on a reduced dimension entry of a \link[SingleCellExperiment]{SingleCellExperiment}.
}
\examples{
library(SingleCellExperiment)
sce <- getTestRnaData.se("pca")
sce <- runAllNeighborSteps.se(
   sce,
   more.tsne.args=list(max.iterations=50),
   more.umap.args=list(num.epochs=50),
   num.threads=2 # to keep R CMD check happy
)
reducedDimNames(sce)
table(sce$clusters)

}
\author{
Aaron Lun
}
