% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_quickAdtQc.R
\name{quickAdtQc.se}
\alias{quickAdtQc.se}
\alias{formatComputeAdtQcMetricsResult}
\title{Quick quality control for ADT data in a SummarizedExperiment}
\usage{
quickAdtQc.se(
  x,
  subsets,
  num.threads = 1,
  thresholds = NULL,
  block = NULL,
  more.suggest.args = list(),
  assay.type = "counts",
  output.prefix = NULL,
  meta.name = "qc",
  flatten = TRUE
)

formatComputeAdtQcMetricsResult(compute.res, flatten = TRUE)
}
\arguments{
\item{x}{A \link[SummarizedExperiment]{SummarizedExperiment} object or one of its subclasses.
Rows correspond to antibody-derived tags (ADTs) and columns correspond to cells.}

\item{subsets}{List of subsets of control tags, see \code{?\link{computeAdtQcMetrics}} for more details.}

\item{num.threads}{Number of threads, to pass to \code{\link{computeAdtQcMetrics}}.}

\item{thresholds}{List containing pre-defined thresholds for each QC metric,
see the return value of \code{\link{suggestAdtQcThresholds}} for the expected format.}

\item{block}{Block assignment for each cell, to pass to \code{\link{suggestAdtQcThresholds}} and \code{\link{filterAdtQcMetrics}}.}

\item{more.suggest.args}{Named list of additional arguments to pass to \code{\link{suggestAdtQcThresholds}}.}

\item{assay.type}{Integer or string specifying the assay of \code{x} containing the ADT count matrix.}

\item{output.prefix}{String containing a prefix to add to the names of the \code{link[SummarizedExperiment]{colData}} columns containing the output statistics.}

\item{meta.name}{String containing the name of the \code{\link[S4Vectors]{metadata}} entry containing additional outputs like the filtering thresholds.
If \code{NULL}, additional outputs are not reported.}

\item{flatten}{Logical scalar indicating whether to flatten the subset proportions into separate columns of the \code{link[SummarizedExperiment]{colData}}.
If \code{FALSE}, the subset proportions are stored in a nested \link[S4Vectors]{DataFrame}.}

\item{compute.res}{\link[S4Vectors]{DataFrame} returned by \code{\link{computeAdtQcMetrics}}.}
}
\value{
For \code{quickAdtQc.se}, \code{x} is returned with additional columns added to its \code{\link[SummarizedExperiment]{colData}}.
Each column contains per-cell values for one of the QC metrics, see \code{\link{computeAdtQcMetrics}} for details.
The suggested thresholds are stored as a list in \code{\link[S4Vectors]{metadata}}.
The \code{colData} also contains a \code{keep} column, specifying which cells are to be retained.

For \code{formatComputeAdtQcMetricsResult}, a \link[S4Vectors]{DataFrame} is returned with the per-cell QC metrics.
}
\description{
Quickly compute quality control (QC) metrics, thresholds and filters from ADT data in a \link[SummarizedExperiment]{SummarizedExperiment}.
This calls \code{\link{computeAdtQcMetrics}} on an assay in a SummarizedExperiment,
followed by \code{\link{suggestAdtQcThresholds}} and \code{\link{filterAdtQcMetrics}} to identify high-quality cells.
}
\examples{
library(SingleCellExperiment)
sce <- altExp(getTestAdtData.se(), "ADT")
sce <- quickAdtQc.se(sce, subsets=list(igg=grepl("IgG", rownames(sce))))
colData(sce)[,c("sum", "detected", "subset.sum.igg")]
metadata(sce)$qc$thresholds
summary(sce$keep)

}
\author{
Aaron Lun
}
