% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_clusterGraph.R
\name{clusterGraph.se}
\alias{clusterGraph.se}
\title{Graph-based clustering of cells in a SingleCellExperiment}
\usage{
clusterGraph.se(
  x,
  num.neighbors = 10,
  num.threads = 1,
  more.build.args = list(),
  method = "multilevel",
  resolution = NULL,
  more.cluster.args = list(),
  reddim.type = "PCA",
  output.name = "clusters",
  meta.name = NULL,
  graph.name = NULL
)
}
\arguments{
\item{x}{A \link[SingleCellExperiment]{SingleCellExperiment} object or one of its subclasses.
Rows correspond to genomic features and columns correspond to cells.}

\item{num.neighbors}{Number of neighbors for constructing the graph, passed to \code{\link{buildSnnGraph}}.}

\item{num.threads}{Number of threads for graph construction, passed to \code{\link{buildSnnGraph}}.}

\item{more.build.args}{Named list of further arguments to be passed to \code{\link{buildSnnGraph}}.}

\item{method}{Clustering method to use, passed to \code{\link{clusterGraph}}.}

\item{resolution}{Resolution for the community detection method in \code{\link{clusterGraph}}.
This is either passed to \code{multilevel.resolution} or \code{leiden.resolution} depending on \code{method}.}

\item{more.cluster.args}{Named list of further arguments to be passed to \code{\link{clusterGraph}}.}

\item{reddim.type}{Integer or string specifying the existing embedding in the \code{\link[SingleCellExperiment]{reducedDim}} of \code{x}.
Alternatively, a named integer or character vector of length 1,
where the name specifies an alternative experiment of \code{x} and the value is the name/index of a \code{reducedDim} entry in that alternative experiment.}

\item{output.name}{String containing the name of the column of the \code{\link[SummarizedExperiment]{colData}} in which to store the cluster assignments.}

\item{meta.name}{String containing the name of the \code{\link[S4Vectors]{metadata}} entry in which to store extra clustering output.
If \code{NULL}, no extra clustering output is stored.}

\item{graph.name}{String containing the name of the \code{\link[S4Vectors]{metadata}} entry in which to store the SNN graph.
If \code{NULL}, the SNN graph is not stored.}
}
\value{
\code{x} is returned with the cluster assignment for each cell stored in the \code{colData}.
Additional clustering output is stored in the \code{metadata}.
}
\description{
Construct a shared-nearest neighbor (SNN) graph from an existing low-dimensional embedding
by calling \code{\link{buildSnnGraph}} on a reduced dimension entry in a \link[SingleCellExperiment]{SingleCellExperiment}.
Then, apply community detection algorithms to obtain clusters of cells with \code{\link{clusterGraph}}.
}
\examples{
sce <- getTestRnaData.se("pca")
sce <- clusterGraph.se(sce)
table(sce$clusters)

}
\author{
Aaron Lun
}
