% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_scoreMarkers.R
\name{scoreMarkers.se}
\alias{scoreMarkers.se}
\alias{formatScoreMarkersResult}
\alias{previewMarkers}
\title{Score marker genes in a SummarizedExperiment}
\usage{
scoreMarkers.se(
  x,
  groups,
  block = NULL,
  num.threads = 1,
  more.marker.args = list(),
  assay.type = "logcounts",
  extra.columns = NULL,
  order.by = TRUE
)

formatScoreMarkersResult(marker.res, extra.columns = NULL, order.by = TRUE)

previewMarkers(
  marker.df,
  columns = order.by,
  default.columns = c("mean", "detected", lfc = "delta.mean.mean"),
  rows = 10,
  order.by = NULL
)
}
\arguments{
\item{x}{A \link[SummarizedExperiment]{SummarizedExperiment} object or one of its subclasses.
Rows correspond to genes and columns correspond to cells.}

\item{groups}{Group assignment for each cell, passed to \code{\link{scoreMarkers}}.}

\item{block}{Block assignment for each cell, passed to \code{\link{scoreMarkers}}.}

\item{num.threads}{Number of threads for marker scoring, passed to \code{\link{scoreMarkers}}.}

\item{more.marker.args}{Named list of additional arguments to pass to \code{\link{scoreMarkers}}.}

\item{assay.type}{Integer or string specifying the assay to use for differential comparisons, usually containing log-normalized expression values.}

\item{extra.columns}{\link[S4Vectors]{DataFrame} containing extra columns to add each DataFrame.
This should have the same number of rows as \code{x}.
For \code{scoreMarkers.se}, this may also be a character vector specifying the columns of \code{\link[SummarizedExperiment]{rowData}} to be added.}

\item{order.by}{String specifying the column to order each DataFrame by.
If \code{TRUE}, a column is automatically chosen from the effect size summaries.
If \code{NULL} or \code{FALSE}, no ordering is performed.}

\item{marker.res}{List containing the result of \code{\link{scoreMarkers}}.}

\item{marker.df}{DataFrame containing the marker statistics for a single group.}

\item{columns, default.columns}{Character vector of the columns to retain in the preview.
This may be named, in which the names are used as the column names.}

\item{rows}{Integer specifying the number of rows to show.
If \code{NULL}, all rows are returned.}
}
\value{
For \code{scoreMarkers.se} and \code{formatScoreMarkersResult}, a \link[S4Vectors]{List} of \link[S4Vectors]{DataFrame}s is returned.
Each DataFrame corresponds to a unique group in \code{groups}.
Each row contains statistics for a gene in \code{x}, with the following columns:
\itemize{
\item \code{mean}, the mean expression in the current group.
\item \code{detected}, the proportion of cells with detected expression in the current group.
\item \code{<effect>.<summary>}, a summary statistic for an effect size,
e.g., \code{cohens.d.mean} contains the mean Cohen's d across comparisons involving the current group.
}

For \code{previewMarkers}, a DataFrame is returned containing the specified columns and rows.
}
\description{
Identify candidate marker genes based on effect sizes from pairwise comparisons between groups of cells,
by calling \code{\link{scoreMarkers}} on an assay of a \link[SummarizedExperiment]{SummarizedExperiment}.
}
\examples{
sce <- getTestRnaData.se("cluster")
markers <- scoreMarkers.se(sce, sce$clusters)
previewMarkers(markers[["1"]], c(effect="cohens.d.mean"))

}
\author{
Aaron Lun
}
