% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_quickCrisprQc.R
\name{quickCrisprQc.se}
\alias{quickCrisprQc.se}
\alias{formatComputeCrisprQcMetricsResult}
\title{Quick quality control for CRISPR data in a SummarizedExperiment}
\usage{
quickCrisprQc.se(
  x,
  num.threads = 1,
  block = NULL,
  more.suggest.args = list(),
  assay.type = "counts",
  output.prefix = NULL,
  meta.name = "qc"
)

formatComputeCrisprQcMetricsResult(compute.res)
}
\arguments{
\item{x}{A \link[SummarizedExperiment]{SummarizedExperiment} object or one of its subclasses.
Rows correspond to CRISPR guides and columns correspond to cells.}

\item{num.threads}{Number of threads, to pass to \code{\link{computeCrisprQcMetrics}}.}

\item{block}{Block assignment for each cell, to pass to \code{\link{suggestCrisprQcThresholds}} and \code{\link{filterCrisprQcMetrics}}.}

\item{more.suggest.args}{Named list of additional arguments to pass to \code{\link{suggestCrisprQcThresholds}}.}

\item{assay.type}{Integer or string specifying the assay of \code{x} containing the CRISPR count matrix.}

\item{output.prefix}{String containing a prefix to add to the names of the \code{link[SummarizedExperiment]{colData}} columns containing the output statistics.}

\item{meta.name}{String containing the name of the \code{\link[S4Vectors]{metadata}} entry containing additional outputs like the filtering thresholds.
If \code{NULL}, additional outputs are not reported.}

\item{compute.res}{List returned by \code{\link[scrapper]{computeCrisprQcMetrics}}.}
}
\value{
For \code{quickCrisprQc.se}, \code{x} is returned with additional columns added to its \code{\link[SummarizedExperiment]{colData}}.
Each column contains per-cell values for one of the QC metrics, see \code{\link[scrapper]{computeCrisprQcMetrics}} for details.
The suggested thresholds are stored as a list in \code{\link[S4Vectors]{metadata}}.
The \code{colData} also contains a \code{keep} column, specifying which cells are to be retained.

For \code{formatComputeCrisprQcMetricsResult}, a \link[S4Vectors]{DataFrame} is returned with the per-cell QC metrics.
}
\description{
Quickly compute quality control (QC) metrics, thresholds and filters from CRISPR data in a \link[SummarizedExperiment]{SummarizedExperiment}.
This calls \code{\link{computeCrisprQcMetrics}} on an assay in a SummarizedExperiment,
followed by \code{\link{suggestCrisprQcThresholds}} and \code{\link{filterCrisprQcMetrics}} to identify high-quality cells.
}
\examples{
library(SingleCellExperiment)
sce <- altExp(getTestCrisprData.se(), "CRISPR Guide Capture")
sce <- quickCrisprQc.se(sce)
colData(sce)[,c("sum", "detected", "max.value", "max.index")]
metadata(sce)$qc$thresholds
summary(sce$keep)

}
\author{
Aaron Lun
}
