% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_normalizeRnaCounts.R
\name{normalizeRnaCounts.se}
\alias{normalizeRnaCounts.se}
\title{Normalize RNA counts in a SummarizedExperiment}
\usage{
normalizeRnaCounts.se(
  x,
  size.factors = NULL,
  center = TRUE,
  block = NULL,
  mode = "lowest",
  log = TRUE,
  pseudo.count = 1,
  assay.type = "counts",
  output.name = "logcounts",
  factor.name = "sizeFactor"
)
}
\arguments{
\item{x}{A \link[SummarizedExperiment]{SummarizedExperiment} object or one of its subclasses.
Rows correspond to genes and columns correspond to cells.}

\item{size.factors}{Numeric vector of length equal to the number of columns of \code{x},
containing the size factor for each cell in \code{x}.
If \code{NULL}, this defaults to the column sums of the count matrix in \code{x}.}

\item{center}{Logical scalar indicating whether to center the \code{size.factors},
see \code{?\link{centerSizeFactors}} for more details.}

\item{block}{Block assignments for each cell, passed to \code{\link{centerSizeFactors}}.}

\item{mode}{How to center size factors in different blocks, see \code{?\link{centerSizeFactors}} for more details.}

\item{log}{Whether to log-transform the normalized expression values, see \code{?\link{normalizeCounts}} for more details.}

\item{pseudo.count}{The pseudo-count for log-transformation, see \code{?\link{normalizeCounts}} for more details.}

\item{assay.type}{Integer or string specifying the assay of \code{x} with the count matrix.}

\item{output.name}{String containing the name of the assay to store the normalized matrix.}

\item{factor.name}{String containing the name of the \code{\link[SummarizedExperiment]{colData}} column in which to store the size factors in the output object.
If \code{NULL}, the size factors are not stored.}
}
\value{
\code{x} is returned with a new assay containing the (log-)normalized matrix.
Size factors are also stored in the \code{\link[SummarizedExperiment]{colData}}.
}
\description{
Compute (log-)normalized expression values after performing scaling normalization of an RNA count matrix.
This calls \code{\link{normalizeCounts}} on an assay of a \link[SummarizedExperiment]{SummarizedExperiment},
after centering the size factors with \code{\link{centerSizeFactors}}.
}
\examples{
library(SingleCellExperiment)
sce <- getTestRnaData.se("qc")
sce <- normalizeRnaCounts.se(sce, size.factors=sce$sum)
assayNames(sce)
summary(sizeFactors(sce))

}
\author{
Aaron Lun
}
