% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_getTestData.R
\name{getTestData.se}
\alias{getTestData.se}
\alias{getTestRnaData.se}
\alias{getTestAdtData.se}
\alias{getTestCrisprData.se}
\title{Get a test scRNA-seq dataset}
\usage{
getTestRnaData.se(at = c("start", "qc", "norm", "hvg", "pca", "cluster"))

getTestAdtData.se(at = c("start", "qc", "norm", "hvg", "pca"))

getTestCrisprData.se(at = c("start", "qc"))
}
\arguments{
\item{at}{String specifying the level of processing.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} containing a dataset at the specified level of processing.
}
\description{
Get a test single-cell dataset with varying levels of processing.
This uses caching to avoid recomputation.
}
\details{
For \code{getTestRnaData}, this is a scRNA-seq dataset of the mouse brain,
where the main experiment contains RNA counts and the alternative experiments contain ERCC and repeat element counts.
This is obtained with \code{\link[scRNAseq]{fetchDataset}("zeisel-brain-2015", "2023-12-14")}.

For \code{getTestAdtData}, this is a CITE-seq dataset of human PBMCs,
where the main experiment contains RNA counts and the alternative experiment contains ADT counts.
This is obtained with \code{\link[scRNAseq]{fetchDataset}("kotliarov-pbmc-2020", "2024-04-18")}.

For \code{getTestCrisprData}, this is a Perturb-seq dataset of a pancreatic beta cell line,
where the main experiment contains RNA counts and the alternative experiment contains CRISPR guide counts.
This is obtained with \code{\link[scRNAseq]{fetchDataset}("cao-pancreas-2025", "2025-10-10", "rqc")}.
}
\examples{
getTestRnaData.se()
getTestAdtData.se()
getTestCrisprData.se()

}
\seealso{
\code{\link[scRNAseq]{fetchDataset}}, used to obtain each dataset.
}
\author{
Aaron Lun
}
