% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_analyze.R
\name{analyze.se}
\alias{analyze.se}
\title{Analyze single-cell data from a SummarizedExperiment}
\usage{
analyze.se(
  x,
  rna.altexp = NA,
  adt.altexp = NULL,
  crispr.altexp = NULL,
  rna.assay.type = "counts",
  adt.assay.type = "counts",
  crispr.assay.type = "counts",
  block = NULL,
  block.name = "block",
  rna.qc.subsets = list(),
  rna.qc.output.prefix = NULL,
  more.rna.qc.args = list(),
  adt.qc.output.prefix = NULL,
  adt.qc.subsets = list(),
  more.adt.qc.args = list(),
  crispr.qc.output.prefix = NULL,
  more.crispr.qc.args = list(),
  filter.cells = TRUE,
  rna.norm.output.name = "logcounts",
  more.rna.norm.args = list(),
  adt.norm.output.name = "logcounts",
  more.adt.norm.args = list(),
  crispr.norm.output.name = "logcounts",
  more.crispr.norm.args = list(),
  rna.hvg.output.prefix = NULL,
  more.rna.hvg.args = list(),
  rna.pca.output.name = "PCA",
  more.rna.pca.args = list(),
  adt.pca.output.name = "PCA",
  more.adt.pca.args = list(),
  use.rna.pcs = TRUE,
  use.adt.pcs = TRUE,
  scale.output.name = "combined",
  more.scale.args = list(),
  mnn.output.name = "MNN",
  more.mnn.args = list(),
  more.umap.args = list(),
  more.tsne.args = list(),
  cluster.graph.output.name = "graph.cluster",
  more.build.graph.args = list(),
  more.cluster.graph.args = list(),
  more.neighbor.args = list(),
  kmeans.clusters = NULL,
  kmeans.clusters.output.name = "kmeans.cluster",
  more.kmeans.args = list(),
  clusters.for.markers = c("graph", "kmeans"),
  more.rna.marker.args = list(),
  more.adt.marker.args = list(),
  more.crispr.marker.args = list(),
  BNPARAM = AnnoyParam(),
  num.threads = 3L
)
}
\arguments{
\item{x}{A \link[SummarizedExperiment]{SummarizedExperiment} object or one of its subclasses.
Rows correspond to genes and columns correspond to cells.}

\item{rna.altexp}{String or integer specifying the alternative experiment of \code{x} containing the RNA data.
If \code{NA}, the main experiment is assumed to contain the RNA data.
If \code{NULL}, it is assumed that no RNA data is available.}

\item{adt.altexp}{String or integer specifying the alternative experiment of \code{x} containing the ADT data.
If \code{NA}, the main experiment is assumed to contain the ADT data.
If \code{NULL}, it is assumed that no ADT data is available.}

\item{crispr.altexp}{String or integer specifying the alternative experiment of \code{x} containing the CRISPR data.
If \code{NA}, the main experiment is assumed to contain the CRISPR data.
If \code{NULL}, it is assumed that no CRISPR data is available.}

\item{rna.assay.type}{String or integer specifying the assay containing the RNA count data.
Only used if \code{rna.altexp} is not \code{NULL}.}

\item{adt.assay.type}{String or integer specifying the assay containing the ADT count data.
Only used if \code{adt.altexp} is not \code{NULL}.}

\item{crispr.assay.type}{String or integer specifying the assay containing the CRISPR count data.
Only used if \code{crispr.altexp} is not \code{NULL}.}

\item{block}{Vector or factor specifying the block of origin (e.g., batch, sample) for each cell in \code{x}.
Alternatively \code{NULL}, if all cells are from the same block.}

\item{block.name}{String specifying the name of the \code{\link[SummarizedExperiment]{colData}} column in which to store the blocking factor.
Only used if \code{block} is not \code{NULL}.
If \code{NULL}, the blocking factor is not stored in the \code{colData}.}

\item{rna.qc.subsets}{Passed to \code{\link{quickRnaQc.se}} as the \code{subsets} argument.
Only used if \code{rna.altexp} is not \code{NULL}.}

\item{rna.qc.output.prefix}{Passed to \code{\link{quickRnaQc.se}} as the \code{output.prefix} argument.
Only used if \code{rna.altexp} is not \code{NULL}.}

\item{more.rna.qc.args}{Named list of additional arguments to pass to \code{\link{quickRnaQc.se}}.
Only used if \code{rna.altexp} is not \code{NULL}.}

\item{adt.qc.output.prefix}{Passed to \code{\link{quickAdtQc.se}} as the \code{output.prefix} argument.
Only used if \code{adt.altexp} is not \code{NULL}.}

\item{adt.qc.subsets}{Passed to \code{\link{quickAdtQc.se}} as the \code{subsets} argument.
Only used if \code{adt.altexp} is not \code{NULL}.}

\item{more.adt.qc.args}{Named list of additional arguments to pass to \code{\link{quickAdtQc.se}}.
Only used if \code{adt.altexp} is not \code{NULL}.}

\item{crispr.qc.output.prefix}{Passed to \code{\link{quickCrisprQc.se}} as the \code{output.prefix} argument.
Only used if \code{crispr.altexp} is not \code{NULL}.}

\item{more.crispr.qc.args}{Named list of additional arguments to pass to \code{\link{quickCrisprQc.se}}.
Only used if \code{crispr.altexp} is not \code{NULL}.}

\item{filter.cells}{Logical scalar indicating whether to filter \code{x} to only retain high-quality cells in all modalities.
If \code{FALSE}, QC metrics and thresholds are still computed but are not used to filter the count matrices.}

\item{rna.norm.output.name}{Passed to \code{\link{normalizeRnaCounts.se}} as the \code{output.name} argument.
Only used if \code{rna.altexp} is not \code{NULL}.}

\item{more.rna.norm.args}{Named list of arguments to pass to \code{\link{normalizeRnaCounts.se}}.
Only used if \code{rna.altexp} is not \code{NULL}.}

\item{adt.norm.output.name}{Passed to \code{\link{normalizeAdtCounts.se}} as the \code{output.name} argument.
Only used if \code{adt.altexp} is not \code{NULL}.}

\item{more.adt.norm.args}{Named list of arguments to pass to \code{\link{normalizeAdtCounts.se}}.
Only used if \code{adt.altexp} is not \code{NULL}.}

\item{crispr.norm.output.name}{Passed to \code{\link{normalizeCrisprCounts.se}} as the \code{output.name} argument.
Only used if \code{crispr.altexp} is not \code{NULL}.}

\item{more.crispr.norm.args}{Named list of arguments to pass to \code{\link{normalizeCrisprCounts.se}}.
Only used if \code{crispr.altexp} is not \code{NULL}.}

\item{rna.hvg.output.prefix}{Passed to \code{\link{chooseRnaHvgs.se}} as the \code{output.prefix} argument.
Only used if \code{rna.altexp} is provided.}

\item{more.rna.hvg.args}{Named list of arguments to pass to \code{\link{chooseRnaHvgs.se}}.
Only used if \code{rna.altexp} is provided.}

\item{rna.pca.output.name}{Passed to \code{\link{runPca.se}} as the \code{output.name} argument.
Only used if \code{rna.altexp} is provided.}

\item{more.rna.pca.args}{Named list of arguments to pass to \code{\link{runPca.se}}.
Only used if \code{rna.altexp} is provided.}

\item{adt.pca.output.name}{Passed to \code{\link{runPca.se}} as the \code{output.name} argument.
Only used if \code{adt.altexp} is provided.}

\item{more.adt.pca.args}{Named list of arguments to pass to \code{\link{runPca.se}}.
Only used if \code{adt.altexp} is provided.}

\item{use.rna.pcs}{Logical scalar indicating whether to use the RNA-derived PCs for downstream steps (i.e., clustering, visualization).
Only used if \code{rna.altexp} is provided.}

\item{use.adt.pcs}{Logical scalar indicating whether to use the ADT-derived PCs for downstream steps (i.e., clustering, visualization).
Only used if \code{adt.altexp} is provided.}

\item{scale.output.name}{Passed to \code{\link{scaleByNeighbors.se}} as the \code{output.name} argument.
Only used if multiple modalities are available and their corresponding \code{use.*.pcs} arguments are \code{TRUE}.}

\item{more.scale.args}{Named list of arguments to pass to \code{\link{scaleByNeighbors.se}}.
Only used if multiple modalities are available and their corresponding \code{use.*.pcs} arguments are \code{TRUE}.}

\item{mnn.output.name}{Passed to \code{\link{correctMnn.se}} as the \code{output.name} argument.
Only used if \code{block} is supplied.}

\item{more.mnn.args}{Named list of arguments to pass to \code{\link{correctMnn.se}}.
Only used if \code{block} is supplied.}

\item{more.umap.args}{Passed to \code{\link{runAllNeighborSteps.se}}.}

\item{more.tsne.args}{Passed to \code{\link{runAllNeighborSteps.se}}.}

\item{cluster.graph.output.name}{Passed to \code{\link{runAllNeighborSteps.se}} as \code{cluster.output.name}.}

\item{more.build.graph.args}{Passed to \code{\link{runAllNeighborSteps.se}}.}

\item{more.cluster.graph.args}{Passed to \code{\link{runAllNeighborSteps.se}}.}

\item{more.neighbor.args}{Passed to \code{\link{runAllNeighborSteps.se}}.}

\item{kmeans.clusters}{Passed to \code{\link{clusterKmeans.se}} as the \code{k} argument.
If \code{NULL}, k-means clustering is not performed.}

\item{kmeans.clusters.output.name}{Passed to \code{\link{clusterKmeans.se}} as the \code{output.name} argument.
Ignored if \code{kmeans.clusters = NULL}.}

\item{more.kmeans.args}{Named list of arguments to pass to \code{\link{clusterKmeans.se}}.
Ignored if \code{kmeans.clusters = NULL}.}

\item{clusters.for.markers}{Character vector of clustering algorithms (either \code{"graph"} or \code{"kmeans"}, specifying the clustering to be used for marker detection.
The first available clustering will be chosen.}

\item{more.rna.marker.args}{Named list of arguments to pass to \code{\link{scoreMarkers.se}} for the RNA data.
Ignored if no suitable clusterings are available or if \code{rna.altexp=NULL}.}

\item{more.adt.marker.args}{Named list of arguments to pass to \code{\link{scoreMarkers.se}} for the ADT data.
Ignored if no suitable clusterings are available or if \code{adt.altexp=NULL}.}

\item{more.crispr.marker.args}{Named list of arguments to pass to \code{\link{scoreMarkers.se}} for the CRISPR data.
Ignored if no suitable clusterings are available or if \code{crispr.altexp=NULL}.}

\item{BNPARAM}{A \link[BiocNeighbors]{BiocNeighborParam} instance specifying the nearest-neighbor search algorithm to use.}

\item{num.threads}{Integer scalar specifying the number of threads to use in each step.}
}
\value{
\code{x} is returned with the results of the analysis.
}
\description{
Execute a simple single-cell analysis pipeline, starting from a count matrix and ending with clusters, visualizations and markers.
This also supports integration of multiple modalities and correction of batch effects.
}
\details{
This function is equivalent to:
\itemize{
\item Running \code{\link{quickRnaQc.se}}, \code{\link{quickAdtQc.se}} and/or \code{\link{quickCrisprQc.se}}, for quality control.
\item Subsetting \code{x} to only retain the high-quality cells in all modalities, based on \code{filter.cells}.
\item Running \code{\link{normalizeRnaCounts.se}}, \code{\link{normalizeAdtCounts.se}} and/or \code{\link{normalizeCrisprCounts.se}}, for normalization.
\item Running \code{\link{chooseRnaHvgs.se}} to identify highly variable genes.
\item Running \code{\link{runPca.se}} on the RNA and/or ADT data.
\item Running \code{\link{scaleByNeighbors.se}} if multiple modalities are present.
\item Running \code{\link{correctMnn.se}} if multiple batches are present in \code{block}.
\item Running \code{\link{runAllNeighborSteps.se}} to obtain t-SNE and UMAP coordinates, and to perform graph-based clustering.
\item Running \code{\link{clusterKmeans.se}} to perform k-means clustering, depending on \code{kmeans.clusters}. 
\item Running \code{\link{scoreMarkers.se}} to compute markers for each modality based on one of the clusterings. 
}
}
\examples{
library(SingleCellExperiment)
sce <- getTestRnaData.se("start")
res <- analyze.se(
    sce, 
    rna.qc.subsets=list(mito=grep("^mt-", rownames(sce))),
    num.threads=2 # keep R CMD check happy
)
assayNames(res$x)
reducedDimNames(res$x)
colData(res$x)
previewMarkers(res$markers$rna[[1]], "cohens.d.mean")

}
\author{
Aaron Lun
}
