% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_aggregateAcrossGenes.R
\name{aggregateAcrossGenes.se}
\alias{aggregateAcrossGenes.se}
\title{Aggregate expression across gene sets in a SummarizedExperiment}
\usage{
aggregateAcrossGenes.se(
  x,
  sets,
  num.threads = 1,
  more.aggr.args = list(),
  assay.type = "logcounts",
  output.name = NULL
)
}
\arguments{
\item{x}{A \link[SummarizedExperiment]{SummarizedExperiment} object or one of its subclasses.
Rows correspond to genes and columns correspond to cells.}

\item{sets}{List of gene sets, see \code{\link{aggregateAcrossCells}} for more details.

Alternatively, \code{sets} may be a \link[S4Vectors]{List} subclass,
in which case the \code{\link[S4Vectors]{mcols}} are used as the \code{\link[SummarizedExperiment]{rowData}} of the output object.
Weighted gene sets can be represented by a list of \pkg{DataFrames} or a \link[IRanges]{DataFrameList},
where each DataFrame contains two columns, i.e., the gene identities and the associated weights.}

\item{num.threads}{Number of threads, passed to \code{\link{aggregateAcrossGenes}}.}

\item{more.aggr.args}{Named list of additional arguments to pass to \code{\link{aggregateAcrossGenes}}.}

\item{assay.type}{Integer or string specifying the assay of \code{x} to be aggregated.}

\item{output.name}{String specifying the assay name in the output object.
Defaults to \code{assay.type} if it is a string, otherwise \code{"aggregated"}.}
}
\value{
A \link[SummarizedExperiment]{SummarizedExperiment} with number of rows equal to the number of gene sets.
The lone assay contains the aggregated values for each gene set for all cells.
The \code{\link[SummarizedExperiment]{colData}} is the same as that of \code{x}.
}
\description{
Aggregate expression values across sets of genes for each cell,
by calling \code{\link{aggregateAcrossGenes}} on an assay in a \link[SummarizedExperiment]{SummarizedExperiment}.
}
\examples{
library(SingleCellExperiment)
sce <- getTestRnaData.se("norm")

library(org.Mm.eg.db)
some.sets <- select(
    org.Mm.eg.db,
    keytype="GO",
    keys=c(
        "GO:0048709", # oligodendrocyte differentiation 
        "GO:0048699", # neuron development
        "GO:0048143"  # astrocyte activation 
    ),
    columns="SYMBOL"
)
some.sets <- some.sets[some.sets$SYMBOL \%in\% rownames(sce),]
sets <- splitAsList(some.sets$SYMBOL, some.sets$GO)

aggregated <- aggregateAcrossGenes.se(sce, sets)
aggregated
assay(aggregated)[,1:10]

}
\author{
Aaron Lun
}
