% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/select_methods.R
\name{select_methods}
\alias{select_methods}
\alias{select_methods,SconeExperiment,character-method}
\alias{select_methods,SconeExperiment,numeric-method}
\title{Get a subset of normalizations from a SconeExperiment object}
\usage{
select_methods(x, methods)

\S4method{select_methods}{SconeExperiment,character}(x, methods)

\S4method{select_methods}{SconeExperiment,numeric}(x, methods)
}
\arguments{
\item{x}{a \code{SconeExperiment} object.}

\item{methods}{either character or numeric specifying the normalizations to
select.}
}
\value{
A \code{SconeExperiment} object with selected method data.
}
\description{
This method let a user extract a subset of normalizations. This
  is useful when the original dataset is large and/or many normalization
  schemes have been applied.

In such cases, the user may want to run scone in mode
  \code{return_norm = "no"}, explore the results, and then select the top
  performing methods for additional exploration.
}
\details{
The numeric method will always return the normalization 
  corresponding to the \code{methods} rows of the \code{scone_params} slot. 
  This means that if \code{\link{scone}} was run with \code{eval=TRUE}, 
  \code{select_methods(x, 1:3)} will return the top three ranked method. If 
  \code{\link{scone}} was run with \code{eval=FALSE}, it will return the 
  first three normalization in the order saved by scone.
}
\section{Functions}{
\itemize{
\item \code{select_methods(x = SconeExperiment, methods = character)}: If 
\code{methods} is a character, it will return the subset of
methods named in \code{methods} (only perfect match). The 
string must be a subset of the \code{row.names} of the slot
\code{scone_params}.

\item \code{select_methods(x = SconeExperiment, methods = numeric)}: If
\code{methods} is a numeric, it will return the subset of methods
according to the scone ranking.

}}
\examples{
set.seed(42)
mat <- matrix(rpois(500, lambda = 5), ncol=10)
colnames(mat) <- paste("X", 1:ncol(mat), sep="")
obj <- SconeExperiment(mat)
res <- scone(obj, scaling=list(none=identity, uq=UQ_FN),
           evaluate=TRUE, k_ruv=0, k_qc=0,
           eval_kclust=2, bpparam = BiocParallel::SerialParam())
select_res = select_methods(res,1:2)

}
