% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repMask.R
\name{repMask}
\alias{repMask}
\title{Provides Coverage metrics in the repeat masker region}
\usage{
repMask(bs, organism, genome)
}
\arguments{
\item{bs}{bsseq object}

\item{organism}{scientific name of the organism of interest,
e.g. Mmusculus or Hsapiens}

\item{genome}{reference alignment, i.e. mm10 or hg38}
}
\value{
Data frame with sample name and coverage in repeat masker regions
}
\description{
Provides Coverage metrics in the repeat masker region
}
\examples{
library(BSgenome.Mmusculus.UCSC.mm10)
library(AnnotationHub)
load(system.file("extdata", 'bsObject.rda', package='scmeth'))
repMask(bs, Mmusculus, 'mm10')
}
