% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpgDensity.R
\name{cpgDensity}
\alias{cpgDensity}
\title{Provides Coverage by the CpG density. CpG Density is defined as the number
of CpGs observed in certain base pair long region.}
\usage{
cpgDensity(bs, organism, windowLength = 1000, small = FALSE)
}
\arguments{
\item{bs}{bsseq object}

\item{organism}{scientific name of the organism of interest,
e.g. Mmusculus or Hsapiens}

\item{windowLength}{Length of the window to calculate the density}

\item{small}{Indicator for a small dataset, cpg density is calculated more
memory efficiently for large dataset but for small dataset a different quicker
method is used
Default value for window length is 1000 basepairs.}
}
\value{
Data frame with sample name and coverage in repeat masker regions
}
\description{
Provides Coverage by the CpG density. CpG Density is defined as the number
of CpGs observed in certain base pair long region.
}
\examples{
library(BSgenome.Hsapiens.NCBI.GRCh38)
directory <- system.file("extdata/bismark_data", package='scmeth')
bs <- HDF5Array::loadHDF5SummarizedExperiment(directory)
cpgDensity(bs, Hsapiens, 1000, small=TRUE)
}
