% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/CoreMethods.R
\docType{methods}
\name{scmapCell2Cluster}
\alias{scmapCell2Cluster}
\alias{scmapCell2Cluster}
\alias{scmapCell2Cluster.SingleCellExperiment}
\alias{scmapCell2Cluster,list-method}
\alias{scmapCell2Cluster}
\title{Approximate k-NN cell-type classification using scfinemap}
\usage{
scmapCell2Cluster(scmapCell_results = NULL, cluster_list = NULL, w = 3,
  threshold = 0.5)

scmapCell2Cluster.SingleCellExperiment(scmapCell_results, cluster_list, w,
  threshold)

\S4method{scmapCell2Cluster}{list}(scmapCell_results = NULL,
  cluster_list = NULL, w = 3, threshold = 0.5)
}
\arguments{
\item{scmapCell_results}{the output of `scmapCell()` with `projection` as its input.}

\item{cluster_list}{list of cell cluster labels correspondint to each index against which the `projection` has been projected}

\item{w}{an integer specifying the number of nearest neighbours to find}

\item{threshold}{the threshold which the maximum similarity between the query and a reference cell must exceed
for the cell-type to be assigned}
}
\value{
The query dataset with the predicted labels attached to colData(query_dat)$cell_type1
}
\description{
Each cell in the query dataset is assigned a cell-type if the similarity between its
nearest neighbour exceeds a threshold AND its w nearest neighbours have the 
same cell-type.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(normcounts = as.matrix(yan)), colData = ann)
# this is needed to calculate dropout rate for feature selection
# important: normcounts have the same zeros as raw counts (fpkm)
counts(sce) <- normcounts(sce)
logcounts(sce) <- log2(normcounts(sce) + 1)
# use gene names as feature symbols
rowData(sce)$feature_symbol <- rownames(sce)
# remove features with duplicated names
sce <- sce[!duplicated(rownames(sce)), ]
sce <- selectFeatures(sce)
sce <- indexCell(sce)
scmapCell_results <- scmapCell(sce, list(metadata(sce)$scmap_cell_index))
sce <- scmapCell2Cluster(scmapCell_results, cluster_list = list(colData(sce)$cell_type1))

}
