% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/CoreMethods.R
\docType{methods}
\name{indexCluster}
\alias{indexCluster}
\alias{indexCluster}
\alias{indexCluster.SingleCellExperiment}
\alias{indexCluster,SingleCellExperiment-method}
\alias{indexCluster}
\title{Create a precomputed Reference}
\usage{
indexCluster(object = NULL, cluster_col = "cell_type1")

indexCluster.SingleCellExperiment(object, cluster_col)

\S4method{indexCluster}{SingleCellExperiment}(object = NULL,
  cluster_col = "cell_type1")
}
\arguments{
\item{object}{SingleCellExperiment object}

\item{cluster_col}{column name in the `colData` slot of the SingleCellExperiment object 
containing the cell classification information}
}
\value{
a `data.frame` containing calculated centroids of the cell types of
the Reference dataset
}
\description{
Calculates centroids of each cell type and merge them into a single table.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(normcounts = as.matrix(yan)), colData = ann)
# this is needed to calculate dropout rate for feature selection
# important: normcounts have the same zeros as raw counts (fpkm)
counts(sce) <- normcounts(sce)
logcounts(sce) <- log2(normcounts(sce) + 1)
# use gene names as feature symbols
rowData(sce)$feature_symbol <- rownames(sce)
# remove features with duplicated names
sce <- sce[!duplicated(rownames(sce)), ]
sce <- selectFeatures(sce)
sce <- indexCluster(sce[rowData(sce)$scmap_features, ])

}
