% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROI.R
\name{plotROI}
\alias{plotROI}
\title{Plot ROIs on spatial.}
\usage{
plotROI(
  spe,
  roi = NULL,
  id = "cell_type",
  label = TRUE,
  show.legend = FALSE,
  reverseY = NULL,
  ...
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{roi}{Character. The name of the group or cell type on which
the roi is computed. All cell types are chosen if NULL or 'overall'.}

\item{id}{Character. The name of the column of colData(spe) containing
the cell type identifiers. Set to cell_type by default.}

\item{label}{Logical. Show ROI label or not.}

\item{show.legend}{Logical. Show legend or not.}

\item{reverseY}{Logical. Whether to reverse Y coordinates. Default is TRUE
if the spe contains an image (even if not plotted) and FALSE if otherwise.}

\item{...}{Parameters pass to \link[scider]{plotSpatial}}
}
\value{
A ggplot object.
}
\description{
Plot ROIs on spatial.
}
\examples{

data("xenium_bc_spe")

coi <- c("Breast cancer", "Fibroblasts")

spe <- gridDensity(spe, coi = coi)

spe <- findROI(spe, coi = coi, method = "walktrap", steps = 5)

plotROI(spe, roi = coi, pt.size = 0.3, pt.alpha = 0.2)

}
