% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeAssay.R
\name{normalizeAssay}
\alias{normalizeAssay}
\title{Perform log normalization for counts}
\usage{
normalizeAssay(
  spe,
  transformation = c("log"),
  scale.factor = 1e+06,
  assay = "counts",
  name = "logcounts"
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{transformation}{Choice of transformation. "Log" for log1p}

\item{scale.factor}{Factor to multiply the count of each cell by. A single
value or a numeric vector equal to number of cells}

\item{assay}{Name of assay in spe to perform the transformation on}

\item{name}{Name of the transformed assay}
}
\value{
A SpatialExperiment object
}
\description{
Perform log normalization for counts
}
\examples{
data("xenium_bc_spe")
spe <- normalizeAssay(spe)
}
