% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getClusters.R
\name{getClusters}
\alias{getClusters}
\title{Cluster cells in spe using graph methods.}
\usage{
getClusters(
  spe,
  nbrs_name = NULL,
  method = c("leiden", "louvain"),
  resolution = 1,
  cluster_name = "cluster",
  seed = 1,
  ...
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{nbrs_name}{Name of neighbour list for clustering. If NULL, will use
the newest one in spe@metadata$nbrs$cell or create one if none are available.}

\item{method}{Clustering methods. Options are leiden and louvain.}

\item{resolution}{Higher resolution for more clusters and lower for fewer
clusters. See \link[igraph]{cluster_leiden} and \link[igraph]{cluster_louvain}}

\item{cluster_name}{Name to store the clusters in spe's
\link[SummarizedExperiment]{colData}}

\item{seed}{seed for clustering}

\item{...}{Other clustering arguments for \link[igraph]{cluster_leiden} or
\link[igraph]{cluster_louvain}}
}
\value{
A spe with the clusters stored in \link[SingleCellExperiment]{reducedDims}.

A SpatialExperiment object
}
\description{
Cluster cells in spe using graph methods.
}
\details{
Cluster cells with igraph using SNN calculated by \link[scider]{findNbrsSNN}.
Any neighbour list in spe@metadata$nbrs$cell can also be used
}
\examples{

data("xenium_bc_spe")
spe <- normalizeAssay(spe)
spe <- runPCA(spe)
spe <- findNbrsSNN(spe,dimred="PCA")
spe <- getClusters(spe, resolution=0.5)
}
