% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hexbin_fc.R
\name{plot_hexbin_fc}
\alias{plot_hexbin_fc}
\title{Plot of fold change of selected gene in single cell data using
   bivariate hexagon cells.}
\usage{
plot_hexbin_fc(
  sce,
  col,
  mod = "RNA",
  type,
  feature,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  colors
)
}
\arguments{
\item{sce}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object.}

\item{col}{A string referring to the name of one column in the meta data of
sce by which to compare. Note this factor can only contain two levels.}

\item{mod}{A string referring to the name of one column in the meta data of
sce by which to compare. Note this factor can only contain two levels.}

\item{type}{A string referring to the name of one column in the meta data of
sce by which to compare. Note this factor can only contain two levels.}

\item{feature}{A string referring to the name of one feature.}

\item{title}{A string containing the title of the plot.}

\item{xlab}{A string containing the title of the x axis.}

\item{ylab}{A string containing the title of the y axis.}

\item{colors}{A vector of strings specifying which colors to use for plotting
the different levels in the selected column of the meta data.}
}
\value{
A \code{\link{ggplot2}{ggplot}} object.
}
\description{
Plot of fold change of selected gene in single cell data using
   bivariate hexagon cells.
}
\details{
This function plots fold change within each
  hexagon, which are calculated with \code{\link{make_hexbin}}.
  Note that the fold change is only accurate if the condition
  investigated is within the same individual. For conditions across
  different individuals different methods that account for
  individual-specific effects are required.
}
\examples{
# For SingleCellExperiment
library(TENxPBMCData)
library(scater)
tenx_pbmc3k <- TENxPBMCData(dataset = "pbmc3k")
rm_ind <- calculateAverage(tenx_pbmc3k) < 0.1
tenx_pbmc3k <- tenx_pbmc3k[!rm_ind, ]
colData(tenx_pbmc3k) <- cbind(colData(tenx_pbmc3k), perCellQCMetrics(tenx_pbmc3k))
tenx_pbmc3k <- logNormCounts(tenx_pbmc3k)
tenx_pbmc3k <- runPCA(tenx_pbmc3k)
tenx_pbmc3k <- make_hexbin(tenx_pbmc3k, 20, dimension_reduction = "PCA")
tenx_pbmc3k$random <- factor(sample(1:2, ncol(tenx_pbmc3k), replace = TRUE))
plot_hexbin_fc(tenx_pbmc3k, col = "random", feature = "ENSG00000187608", type = "counts")
}
