% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hexbin_density.R
\name{plot_hexbin_density}
\alias{plot_hexbin_density}
\title{Plot of density of observations from single cell data
   in bivariate hexagon cells.}
\usage{
plot_hexbin_density(sce, title = NULL, xlab = NULL, ylab = NULL)
}
\arguments{
\item{sce}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object.}

\item{title}{A string containing the title of the plot.}

\item{xlab}{A string containing the title of the x axis.}

\item{ylab}{A string containing the title of the y axis.}
}
\value{
A \code{\link{ggplot2}{ggplot}} object.
}
\description{
Plot of density of observations from single cell data
   in bivariate hexagon cells.
}
\examples{
# For SingleCellExperiment object
library(TENxPBMCData)
library(scater)
tenx_pbmc3k <- TENxPBMCData(dataset = "pbmc3k")
rm_ind <- calculateAverage(tenx_pbmc3k) < 0.1
tenx_pbmc3k <- tenx_pbmc3k[!rm_ind, ]
tenx_pbmc3k <- logNormCounts(tenx_pbmc3k)
tenx_pbmc3k <- runPCA(tenx_pbmc3k)
tenx_pbmc3k <- make_hexbin(tenx_pbmc3k, 10, dimension_reduction = "PCA")
plot_hexbin_density(tenx_pbmc3k)
}
