% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxds.R
\name{cxds}
\alias{cxds}
\title{Find doublets/multiplets in UMI scRNA-seq data;}
\usage{
cxds(
  sce,
  ntop = 500,
  binThresh = 0,
  verb = FALSE,
  retRes = FALSE,
  estNdbl = FALSE
)
}
\arguments{
\item{sce}{single cell experiment (\code{SingleCellExperiment}) object to analyze; needs \code{counts} in assays slot.}

\item{ntop}{integer, indimessageing number of top variance genes to consider. Default: 500}

\item{binThresh}{integer, minimum counts to consider a gene "present" in a cell. Default: 0}

\item{verb}{progress messages. Default: FALSE}

\item{retRes}{logical, whether to return gene pair scores & top-scoring gene pairs? Default: FALSE.}

\item{estNdbl}{logical, should the numer of doublets be estimated from the data. Enables doublet calls. Default:FALSE. Use with caution.}
}
\value{
sce input sce object \code{SingleCellExperiment} with doublet scores added to colData as "cxds_score" column.
}
\description{
Annotates doublets/multiplets using co-expression based approach
}
\examples{
data("sce_chcl")
## create small data set using only 100 cells
sce_chcl_small = sce_chcl[, 1:100]
sce_chcl_small = cxds(sce_chcl_small)
}
