% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{view.aspects}
\alias{view.aspects}
\title{View heatmap}
\usage{
view.aspects(mat, row.clustering = NA, cell.clustering = NA, zlim = c(-1,
  1) * quantile(mat, p = 0.95), row.cols = NULL, col.cols = NULL,
  cols = colorRampPalette(c("darkgreen", "white", "darkorange"), space =
  "Lab")(1024), show.row.var.colors = TRUE, top = Inf, ...)
}
\arguments{
\item{mat}{Numeric matrix}

\item{row.clustering}{Row dendrogram}

\item{cell.clustering}{Column dendrogram}

\item{zlim}{Range of the normalized gene expression levels, inputted as a list: c(lower_bound, upper_bound). Values outside this range will be Winsorized. Useful for increasing the contrast of the heatmap visualizations. Default, set to the 5th and 95th percentiles.}

\item{row.cols}{Matrix of row colors.}

\item{col.cols}{Matrix of column colors. Useful for visualizing cell annotations such as batch labels.}

\item{cols}{Heatmap colors}

\item{show.row.var.colors}{Boolean of whether to show row variance as a color track}

\item{top}{Restrict output to the top n aspects of heterogeneity}

\item{...}{additional arguments for heatmap plotting}
}
\value{
A heatmap
}
\description{
Internal function to visualize aspects of transcriptional heterogeneity as a heatmap. Used by \code{\link{pagoda.view.aspects}}.
}

