% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sccomp_test.R
\name{sccomp_test}
\alias{sccomp_test}
\title{sccomp_test}
\usage{
sccomp_test(
  .data,
  contrasts = NULL,
  percent_false_positive = 5,
  test_composition_above_logit_fold_change = 0.1,
  pass_fit = TRUE
)
}
\arguments{
\item{.data}{A tibble. The result of sccomp_estimate.}

\item{contrasts}{A vector of character strings. For example if your formula is \code{~ 0 + treatment} and the factor treatment has values \code{yes} and \code{no}, your contrast could be "constrasts = c(treatmentyes - treatmentno)".}

\item{percent_false_positive}{A real between 0 and 100 non included. This used to identify outliers with a specific false positive rate.}

\item{test_composition_above_logit_fold_change}{A positive integer. It is the effect threshold used for the hypothesis test. A value of 0.2 correspond to a change in cell proportion of 10\% for a cell type with baseline proportion of 50\%. That is, a cell type goes from 45\% to 50\%. When the baseline proportion is closer to 0 or 1 this effect thrshold has consistent value in the logit uncontrained scale.}

\item{pass_fit}{A boolean. Whether to pass the Stan fit as attribute in the output. Because the Stan fit can be very large, setting this to FALSE can be used to lower the memory imprint to save the output.}
}
\value{
A tibble (\code{tbl}), with the following columns:
\itemize{
\item cell_group - The cell groups being tested.
\item parameter - The parameter being estimated from the design matrix described by the input formula_composition and formula_variability.
\item factor - The covariate factor in the formula, if applicable (e.g., not present for Intercept or contrasts).
\item c_lower - Lower (2.5\%) quantile of the posterior distribution for a composition (c) parameter.
\item c_effect - Mean of the posterior distribution for a composition (c) parameter.
\item c_upper - Upper (97.5\%) quantile of the posterior distribution for a composition (c) parameter.
\item c_pH0 - Probability of the c_effect being smaller or bigger than the \code{test_composition_above_logit_fold_change} argument.
\item c_FDR - False-discovery rate of the null hypothesis (no difference) for a composition (c).
\item c_n_eff - Effective sample size - the number of independent draws in the sample, the higher the better.
\item c_R_k_hat - R statistic, a measure of chain equilibrium, should be within 0.05 of 1.0.
\item v_lower - Lower (2.5\%) quantile of the posterior distribution for a variability (v) parameter.
\item v_effect - Mean of the posterior distribution for a variability (v) parameter.
\item v_upper - Upper (97.5\%) quantile of the posterior distribution for a variability (v) parameter.
\item v_pH0 - Probability of the null hypothesis (no difference) for a variability (v).
\item v_FDR - False-discovery rate of the null hypothesis (no difference) for a variability (v).
\item v_n_eff - Effective sample size for a variability (v) parameter.
\item v_R_k_hat - R statistic for a variability (v) parameter.
\item count_data - Nested input count data.
}
}
\description{
This function test contrasts from a sccomp result.
}
\examples{

print("cmdstanr is needed to run this example.")
# Note: Before running the example, ensure that the 'cmdstanr' package is installed:
# install.packages("cmdstanr", repos = c("https://stan-dev.r-universe.dev/", getOption("repos")))

\donttest{
  if (instantiate::stan_cmdstan_exists()) {
    data("counts_obj")

    estimates = sccomp_estimate(
      counts_obj,
      ~ 0 + type, ~1, "sample", "cell_group", "count",
      cores = 1
    ) |>
    sccomp_test("typecancer - typebenign")
  }
}

}
\references{
S. Mangiola, A.J. Roth-Schulze, M. Trussart, E. Zozaya-Valdés, M. Ma, Z. Gao, A.F. Rubin, T.P. Speed, H. Shim, & A.T. Papenfuss, sccomp: Robust differential composition and variability analysis for single-cell data, Proc. Natl. Acad. Sci. U.S.A. 120 (33) e2203828120, https://doi.org/10.1073/pnas.2203828120 (2023).
}
