% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sccomp_boxplot.R
\name{sccomp_boxplot}
\alias{sccomp_boxplot}
\title{sccomp_boxplot}
\usage{
sccomp_boxplot(
  .data,
  factor,
  significance_threshold = 0.05,
  test_composition_above_logit_fold_change = attr(.data,
    "test_composition_above_logit_fold_change"),
  remove_unwanted_effects = FALSE
)
}
\arguments{
\item{.data}{A tibble containing the results from \code{sccomp_estimate} and \code{sccomp_test}, including the columns: cell_group name, sample name, read counts, factor(s), p-values, and significance indicators.}

\item{factor}{A character string specifying the factor of interest included in the model for stratifying the boxplot.}

\item{significance_threshold}{A numeric value indicating the False Discovery Rate (FDR) threshold for labeling significant cell-groups. Defaults to 0.05.}

\item{test_composition_above_logit_fold_change}{A positive numeric value representing the effect size threshold used in the hypothesis test. A value of 0.2 corresponds to a change in cell proportion of approximately 10\% for a cell type with a baseline proportion of 50\% (e.g., from 45\% to 55\%). This threshold is consistent on the logit-unconstrained scale, even when the baseline proportion is close to 0 or 1.}

\item{remove_unwanted_effects}{A logical value indicating whether to remove unwanted variation from the data before plotting. Defaults to \code{FALSE}.}
}
\value{
A \code{ggplot} object representing the boxplot of cell proportions across samples, stratified by the specified factor.
}
\description{
Creates a boxplot visualization of the model results from \code{sccomp}. This function plots the estimated cell proportions across samples, highlighting significant changes in cell composition according to a specified factor.
}
\examples{

print("cmdstanr is needed to run this example.")
# Note: Before running the example, ensure that the 'cmdstanr' package is installed:
# install.packages("cmdstanr", repos = c("https://stan-dev.r-universe.dev/", getOption("repos")))

\donttest{
if (instantiate::stan_cmdstan_exists()) {
    data("counts_obj")

    estimate <- sccomp_estimate(
      counts_obj,
      formula_composition = ~ type,
      formula_variability = ~ 1,
      sample = "sample",
      cell_group = "cell_group",
      abundance = "count",
      cores = 1
    ) |>
    sccomp_test()

    # Plot the boxplot of estimated cell proportions
    sccomp_boxplot(
        .data = estimate,
        factor = "type",
        significance_threshold = 0.05
    )
}
}
}
\references{
S. Mangiola, A.J. Roth-Schulze, M. Trussart, E. Zozaya-Valdés, M. Ma, Z. Gao, A.F. Rubin, T.P. Speed, H. Shim, & A.T. Papenfuss, sccomp: Robust differential composition and variability analysis for single-cell data, Proc. Natl. Acad. Sci. U.S.A. 120 (33) e2203828120, https://doi.org/10.1073/pnas.2203828120 (2023).
}
