% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotReducedDim.R
\name{plotReducedDim}
\alias{plotReducedDim}
\title{Plot reduced dimensions}
\usage{
plotReducedDim(
  object,
  dimred,
  ncomponents = 2,
  percentVar = NULL,
  colour_by = color_by,
  shape_by = NULL,
  size_by = NULL,
  order_by = NULL,
  by_exprs_values = "logcounts",
  text_by = NULL,
  text_size = 5,
  text_colour = text_color,
  label_format = c("\%s \%i", " (\%i\%\%)"),
  other_fields = list(),
  text_color = "black",
  color_by = NULL,
  swap_rownames = NULL,
  point.padding = NA,
  force = 1,
  rasterise = FALSE,
  scattermore = FALSE,
  bins = NULL,
  summary_fun = "sum",
  hex = FALSE,
  by.assay.type = by_exprs_values,
  min.value = NULL,
  max.value = NULL,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object.}

\item{dimred}{A string or integer scalar indicating the reduced dimension
result in \code{reducedDims(object)} to plot.}

\item{ncomponents}{A numeric scalar indicating the number of dimensions to
plot, starting from the first dimension.
Alternatively, a numeric vector specifying the dimensions to be plotted.}

\item{percentVar}{A numeric vector giving the proportion of variance in
expression explained by each reduced dimension.
Only expected to be used in PCA settings, e.g., in the
\code{\link[scater]{plotPCA}} function.}

\item{colour_by}{Specification of a column metadata field or a feature to
colour by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for
possible values.}

\item{shape_by}{Specification of a column metadata field or a feature to
shape by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for
possible values.}

\item{size_by}{Specification of a column metadata field or a feature to
size by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for
possible values.}

\item{order_by}{Specification of a column metadata field or a feature to
order points by, see the \code{by} argument in
\code{?\link{retrieveCellInfo}} for possible values.}

\item{by_exprs_values}{Alias for \code{by.assay.type}.}

\item{text_by}{String specifying the column metadata field with which to add
text labels on the plot.
This must refer to a categorical field, i.e., coercible into a factor.
Alternatively, an \link{AsIs} vector or data.frame, see
\code{?\link{retrieveCellInfo}}.}

\item{text_size}{Numeric scalar specifying the size of added text.}

\item{text_colour}{String specifying the colour of the added text.}

\item{label_format}{Character vector of length 2 containing format strings
to use for the axis labels.
The first string expects a string containing the result type (e.g.,
\code{"PCA"}) and an integer containing the component number,
while the second string shows the rounded percentage of variance explained
and is only relevant when this information is provided in \code{object}.}

\item{other_fields}{Additional cell-based fields to include in the
data.frame, see \code{?"\link{scater-plot-args}"} for details.}

\item{text_color}{Alias to \code{text_colour}.}

\item{color_by}{Alias to \code{colour_by}.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labelling plot
elements.}

\item{point.padding, force}{See \code{?ggrepel::geom_text_repel}.}

\item{rasterise}{Whether to rasterise the points in the plot with
\code{\link[ggrastr]{rasterise}}. To control the dpi, set
\code{options(ggrastr.default.dpi)},
for example \code{options(ggrastr.default.dpi=300)}.}

\item{scattermore}{Logical, whether to use the \code{scattermore} package to
greatly speed up plotting a large number of cells. Use \code{point_size =
0} for the most performance gain.}

\item{bins}{Number of bins, can be different in x and y, to bin and summarize
the points and their values, to avoid overplotting. If \code{NULL}
(default), then the points are plotted without binning. Only used when both
x and y are numeric.}

\item{summary_fun}{Function to summarize the feature value of each point
(e.g. gene expression of each cell) when the points binned, defaults to
\code{sum}. Can be either the name of the function or the function itself.}

\item{hex}{Logical, whether to use \code{\link{geom_hex}}.}

\item{by.assay.type}{A string or integer scalar specifying which assay to
obtain expression values from,
for use in point aesthetics - see the \code{assay.type} argument in
\code{?\link{retrieveCellInfo}}.}

\item{min.value, max.value}{Minimum and maximum values, beyond which \code{colour_by} values (if numeric) are truncated. Can be set to a numeric value to prevent outlying values from skewing the colour scale, or set to quantiles of the \code{colour_by} variable by setting to (e.g.) \code{"q10"} for the 10th quantile.}

\item{...}{Additional arguments for visualization, see
\code{?"\link{scater-plot-args}"} for details.}
}
\value{
A ggplot object
}
\description{
Plot cell-level reduced dimension results stored in a SingleCellExperiment
object.
}
\details{
If \code{ncomponents} is a scalar equal to 2, a scatterplot of the first two
dimensions is produced.
If \code{ncomponents} is greater than 2, a pairs plots for the top
dimensions is produced.

Alternatively, if \code{ncomponents} is a vector of length 2, a scatterplot
of the two specified dimensions is produced.
If it is of length greater than 2, a pairs plot is produced containing all
pairwise plots between the specified dimensions.

The \code{text_by} option will add factor levels as labels onto the plot,
placed at the median coordinate across all points in that level.
This is useful for annotating position-related metadata (e.g., clusters)
when there are too many levels to distinguish by colour.
It is only available for scatterplots.
}
\note{
Arguments \code{shape_by} and \code{size_by} are ignored when
\code{scattermore = TRUE}. Using \code{scattermore} is only recommended for
very large datasets to speed up plotting. Small point size is also
recommended. For larger point size, the point shape may be distorted. Also,
when \code{scattermore = TRUE}, the \code{point_size} argument works
differently.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)

example_sce <- runPCA(example_sce, ncomponents=5)
plotReducedDim(example_sce, "PCA")
plotReducedDim(example_sce, "PCA", colour_by="Cell_Cycle")
plotReducedDim(example_sce, "PCA", colour_by="Gene_0001")

plotReducedDim(example_sce, "PCA", ncomponents=5)
plotReducedDim(example_sce, "PCA", ncomponents=5, colour_by="Cell_Cycle",
    shape_by="Treatment")

# Use scattermore
plotPCA(example_sce, ncomponents = 4, scattermore = TRUE, point_size = 3)

# Bin to show point density
plotPCA(example_sce, bins = 10)
# Bin to summarize values (default is sum)
plotPCA(example_sce, bins = 10, colour_by = "Gene_0001")

}
\author{
Davis McCarthy, with modifications by Aaron Lun
}
