% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFullScan.R
\name{runFullScan}
\alias{runFullScan}
\title{runFullScan}
\usage{
runFullScan(
  annotation,
  mods = NULL,
  annoFilter = NULL,
  extract = c("UTRonly", "withORF", "exons"),
  onlyCanonical = TRUE,
  shadow = 15,
  cores = 1,
  maxLogKd = c(-1, -1.5),
  save.path = NULL,
  ...
)
}
\arguments{
\item{annotation}{A \code{\link{ScanMiRAnno}} object}

\item{mods}{An optional `KdModelList` (defaults to the one in `annotation`)}

\item{annoFilter}{An optional `AnnotationFilter` or `AnnotationFilterList` to
filter the set of transcripts to be extracted}

\item{extract}{Which parts of the transcripts to extract. For `UTRonly`
(default) only the 3' UTR regions are extracted, `withORF` additionally
extracts the coding regions, and `exons` extracts all exons}

\item{onlyCanonical}{passed to \code{\link[scanMiR]{findSeedMatches}}}

\item{shadow}{The size of the ribosomal shadow at the UTR starts}

\item{cores}{The number of threads to use. Alternatively accepts a
\code{\link[BiocParallel]{BiocParallelParam-class}}, as for instance produced
by \code{\link[BiocParallel]{MulticoreParam}}.}

\item{maxLogKd}{The maximum log_kd of sites to report}

\item{save.path}{Optional, the path to which to save the results}

\item{...}{Arguments passed to \code{\link[scanMiR]{findSeedMatches}}}
}
\value{
A `GRanges` object
}
\description{
Runs a full miRNA scan on all protein-coding transcripts (or UTRs) of an
annotation.
}
\examples{
anno <- ScanMiRAnno("fake")
m <- runFullScan( annotation=anno )
m
}
