% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTranscriptSequence.R
\name{plotSitesOnUTR}
\alias{plotSitesOnUTR}
\title{plotSitesOnUTR}
\usage{
plotSitesOnUTR(
  tx,
  annotation,
  miRNA = NULL,
  label_6mers = FALSE,
  label_notes = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{tx}{An ensembl TranscriptID}

\item{annotation}{A \code{\link{ScanMiRAnno}} object.}

\item{miRNA}{A miRNA name in the mirbase format (eg. "hsa-miR-485-5p"), a
`KdModel`, or a miRNA sequence or target seed.}

\item{label_6mers}{Logical whether to label 6mer sites in the plot}

\item{label_notes}{Logical whether to label special sites in the plot (as
TDMD or Slicing)}

\item{verbose}{Logical; whether to print updates on the processing}

\item{...}{Any further arguments passed to
\code{\link[scanMiR]{findSeedMatches}}}
}
\value{
Returns a ggplot.
}
\description{
Wrapper function with minimal arguments to plot scanMiR-Binding
sites on 3'UTRs of specified transcripts. The red dashed line indicates the
background threshhold is indicated, the lightblue dashed line shows the
average 8mer dissociation rate of the given miRNA
}
\examples{
anno <- ScanMiRAnno("fake")
plotSitesOnUTR( tx="ENSTFAKE0000056456", annotation=anno,
                miRNA="hsa-miR-155-5p" )
}
