% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{set_model_info}
\alias{set_model_info}
\alias{set_model_info,eQTLObject-method}
\title{Set model specification in an eQTLObject}
\usage{
set_model_info(x, value)

\S4method{set_model_info}{eQTLObject}(x, value)
}
\arguments{
\item{x}{An \code{eQTLObject}.}

\item{value}{A character string specifying the model (e.g., "zinb",
"poisson", "linear").}
}
\value{
An updated \code{eQTLObject} with the new model specification.

An updated \code{eQTLObject}.
}
\description{
Set model specification in an eQTLObject

Method to set eQTLObject used model information.
}
\examples{
  data(EQTL_obj)
  useModel <- "zinb"
  set_model_info(EQTL_obj, useModel)

  data(EQTL_obj)
  useModel <- "zinb"
  set_model_info(EQTL_obj, useModel)

}
