% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_outliers-visualizeQTL.R
\name{remove_outliers}
\alias{remove_outliers}
\title{Remove outliers from gene expression data and update cell groups.}
\usage{
remove_outliers(exprsMat, Geneid, A_cells, B_cells, C_cells = NULL)
}
\arguments{
\item{exprsMat}{Input gene expression matrix with genes as rows and cells as
columns.}

\item{Geneid}{Character string specifying the gene ID to examine.}

\item{A_cells}{Character vector of cell names belonging to genotype group A.}

\item{B_cells}{Character vector of cell names belonging to genotype group B.}

\item{C_cells}{Optional character vector of cell names belonging to genotype
group C; if \code{NULL}, function returns two genotype groups.}
}
\value{
A named list of filtered cell vectors.
}
\description{
This function identifies and removes outlier expression values for a
specified gene based on the Median Absolute Deviation (MAD) method.
It then filters provided genotype-based cell groups, returning only
cells with non-outlier expression values.
}
\examples{
## Mock expression matrix
set.seed(123)
exprsMat <- matrix(rnorm(200), nrow = 5)
rownames(exprsMat) <- paste0("Gene", 1:nrow(exprsMat))
colnames(exprsMat)  <- paste0("cell", 1:ncol(exprsMat))
A_cells <- colnames(exprsMat)[1:13] # Example A cell list
B_cells <- colnames(exprsMat)[14:26]  # Example B cell list
C_cells <- colnames(exprsMat)[27:40]  # Example C cell list
remove_outliers(exprsMat, "Gene1", A_cells, B_cells, C_cells)
}
