% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeGene.R
\name{normalizeGene}
\alias{normalizeGene}
\title{Normalize gene expression data.}
\usage{
normalizeGene(eQTLObject, method = "logNormalize")
}
\arguments{
\item{eQTLObject}{An S4 object of class \code{eQTLObject} containing the raw
gene expression matrix.}

\item{method}{Character string specifying the normalization method to use.
Must be one of \code{"logNormalize"}, \code{"CPM"}, \code{"TPM"},
\code{"DESeq"}, or \code{"limma"}. Default is \code{"logNormalize"}.}
}
\value{
An \code{eQTLObject} with the normalized gene expression matrix
stored in the slot named \code{"normExpMat"}.
}
\description{
This function performs normalization of the gene expression matrix stored
within an \code{eQTLObject}, aiming to remove technical biases and
improve comparability across cells. Multiple normalization methods are
supported, including "logNormalize", "CPM", "TPM", "DESeq", and "limma".
}
\examples{
data(EQTL_obj)
eqtl <- normalizeGene(EQTL_obj, method = "logNormalize")
}
