% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_abs_b.R
\name{filter_by_abs_b}
\alias{filter_by_abs_b}
\title{Filter a data frame of SNP–gene pairs by absolute beta.}
\usage{
filter_by_abs_b(result, logfcThreshold)
}
\arguments{
\item{result}{A data frame that containing SNP–gene pairs and their beta
values (b-value).}

\item{logfcThreshold}{A numeric value specifying the minimum absolute
b-value to retain. Default is 0.1.}
}
\value{
A data frame containing only rows with absolute b-values above the
specified threshold.
}
\description{
Filter a data frame of SNP–gene pairs by absolute beta.
}
\examples{
example_result <- data.frame(
  gene = c("Gene1", "Gene2", "Gene3", "Gene4"),
  SNP = c("SNP1", "SNP2", "SNP3", "SNP4"),
  b = c(-2.5, 1.0, -0.5, 3.0))
logfcThreshold <- 0.1
filtered_result <- filter_by_abs_b(example_result, logfcThreshold)
}
