% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_integrate.R
\name{sc_integrate}
\alias{sc_integrate}
\title{Integrate multi-omic scRNA-Seq and scATAC-Seq data into a MultiAssayExperiment}
\usage{
sc_integrate(
  sce_list,
  barcode_match_file = NULL,
  sce_column_to_barcode_files = NULL,
  rev_comp = NULL,
  cell_line_info = NULL,
  output_folder = NULL
)
}
\arguments{
\item{sce_list}{A list of SCE objects, named with the corresponding technologies}

\item{barcode_match_file}{A .csv file with columns corresponding to the barcodes for each tech}

\item{sce_column_to_barcode_files}{A list of files containing the barcodes for each tech (if not needed then give a `NULL` entry)}

\item{rev_comp}{A named list of technologies and logical flags specifying if reverse complements should be applyed for sequences (if not needed then provide a `NULL` entry)}

\item{cell_line_info}{A list of files, each of which contains 2 columns corresponding to the barcode and cell line for each tech (if not needed then provide a `NULL` entry)}

\item{output_folder}{The path to the output folder}
}
\value{
Returns a MultiAssayExperiment containing the scRNA-Seq and scATAC-Seq data produced by the scPipe pipelines
}
\description{
Generates an integrated SCE object with scRNA-Seq and scATAC-Seq data produced by the scPipe pipelines
}
\examples{
\dontrun{
sc_integrate(
   sce_list = list("RNA" = sce.rna, "ATAC" = sce.atac),
   barcode_match_file = bc_match_file,
   sce_column_to_barcode_files = list("RNA" = rna_bc_anno, "ATAC" = NULL),
   rev_comp = list("RNA" = FALSE, "ATAC" = TRUE),
   cell_line_info = list("RNA" = rna_cell_line_info, "ATAC" = atac_cell_line_info,)
   output_folder = output_folder
   )
}  

}
