% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_scPipeCPP.R
\name{sc_detect_bc}
\alias{sc_detect_bc}
\title{sc_detect_bc}
\usage{
sc_detect_bc(
  infq,
  outcsv,
  prefix = "CELL_",
  bc_len,
  max_reads = 1e+06,
  min_count = 10,
  number_of_cells = 10000,
  max_mismatch = 1,
  white_list_file = NULL
)
}
\arguments{
\item{infq}{input fastq file, should be the output file of
\code{sc_trim_barcode}}

\item{outcsv}{output barcode annotation}

\item{prefix}{the prefix of cell name (default: `CELL_`)}

\item{bc_len}{the length of cell barcode, should be consistent with bl1+bl2
in \code{sc_trim_barcode}}

\item{max_reads}{the maximum of reads processed (default: 1,000,000)}

\item{min_count}{minimum counts to keep, barcode will be discarded if
it has lower count. Default value is 10. This should be set according
to \code{max_reads}.}

\item{number_of_cells}{number of cells kept in result. (default: 10000)}

\item{max_mismatch}{the maximum mismatch allowed. Barcodes within this
number will be considered as sequence error and merged. (default: 1)}

\item{white_list_file}{a file that list all the possible barcodes
each row is a barcode sequence. the list for 10x can be found at:
https://community.10xgenomics.com/t5/Data-Sharing/List-of-valid-cellular-barcodes/td-p/527
(default: NULL)}
}
\value{
no return
}
\description{
Detect cell barcode and generate the barcode annotation
}
\examples{
\dontrun{
# `sc_detect_bc`` should run before `sc_demultiplex` for
# Drop-seq or 10X protocols
sc_detect_bc("input.fastq","output.cell_index.csv",bc_len=8)
sc_demultiplex(...,"output.cell_index.csv")
}


}
