% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_scPipeCPP.R
\name{sc_correct_bam_bc}
\alias{sc_correct_bam_bc}
\title{sc_correct_bam_bc}
\usage{
sc_correct_bam_bc(
  inbam,
  outbam,
  bc_anno,
  max_mis = 1,
  bam_tags = list(am = "YE", ge = "GE", bc = "BC", mb = "OX"),
  mito = "MT",
  nthreads = 1
)
}
\arguments{
\item{inbam}{input bam file. This should be the output of
\code{sc_exon_mapping}}

\item{outbam}{output bam file with updated cell barcode}

\item{bc_anno}{barcode annotation, first column is cell id, second column
is cell barcode sequence}

\item{max_mis}{maximum mismatch allowed in barcode. (default: 1)}

\item{bam_tags}{list defining BAM tags where mapping information is
stored.
\itemize{
  \item "am": mapping status tag
  \item "ge": gene id
  \item "bc": cell barcode tag
  \item "mb": molecular barcode tag
}}

\item{mito}{mitochondrial chromosome name.
This should be consistent with the chromosome names in the bam file.}

\item{nthreads}{number of threads to use. (default: 1)}
}
\value{
no return
}
\description{
update the cell barcode tag in bam file with corrected barcode
output to a new bam file. the function will be useful for methods
that use the cell barcode information from bam file, such as `Demuxlet`
}
\examples{
data_dir="celseq2_demo"
barcode_annotation_fn = system.file("extdata", "barcode_anno.csv",
    package = "scPipe")
\dontrun{
# refer to the vignettes for the complete workflow
...
sc_correct_bam_bc(file.path(data_dir, "out.map.bam"),
    file.path(data_dir, "out.map.clean.bam"),
    barcode_annotation_fn)
...
}

}
