% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomart_methods.R
\name{get_genes_by_GO}
\alias{get_genes_by_GO}
\title{Get genes related to certain GO terms from biomart database}
\usage{
get_genes_by_GO(
  returns = "ensembl_gene_id",
  dataset = "mmusculus_gene_ensembl",
  go = NULL
)
}
\arguments{
\item{returns}{the gene id which is set as return. Default to be ensembl id
A possible list of attributes can be retrieved using the
function \code{listAttributes} from \code{biomaRt} package. The commonly used
id types are `external_gene_name`, `ensembl_gene_id` or `entrezgene`.}

\item{dataset}{Dataset you want to use. List of possible datasets can be
retrieved using the function \code{listDatasets} from \code{biomaRt} package.}

\item{go}{a vector of GO terms}
}
\value{
a vector of gene ids.
}
\description{
Get genes related to certain GO terms from biomart database
}
\details{
Get genes related to certain GO terms from biomart database
}
\examples{
# get all genes under GO term GO:0005739 in mouse, return ensembl gene id
get_genes_by_GO(returns="ensembl_gene_id",
    dataset="mmusculus_gene_ensembl",
    go=c('GO:0005739'))

}
